using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;
using CFW.Auth;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;
using CFW.Database.CommandBuilder;
using CFW.Models;

namespace TaskManager.Models 
{
    /// <summary>
    /// Tasks f`
    /// </summary>
    [Serializable()]
	public class TasksModel : DbModel<TasksEntity,TasksProperty>
	{
        List<Association> associations;
        /// <summary>
        /// default construct  
        /// </summary>
        public TasksModel() : base()
        {
            createAssociations();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public TasksModel(Connection connection) : base(connection)
        {
            createAssociations();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public TasksModel(Connection connection, TasksProperty property) : base(connection,property)
        {
            createAssociations();
        }

        void createAssociations()
        {
            associations = new List<Association>();
            associations.Add(
                new Association(
                    "category", 
                    Association.Multiplicity.TO_ONE, 
                    new CategoriesProperty(), 
                    new StringCondition("TASKS.CATEGORY_ID = CATEGORIES.ID"))
            );
            associations.Add(
                new Association(
                    "statuses", 
                    Association.Multiplicity.TO_ONE, 
                    new StatusesProperty(),
                    new StringCondition("TASKS.STATUS_ID = STATUSES.ID"))
            );
        }
        public List<TasksEntity> findByDate(DateTime date)
        {
            try
            {
                this.connect("default");
                ExpressionFactory ef = connection.getExpressionFactory();

                Identity currentIdentity = (AuthProviderFactory.GetInstance()).GetIdentity();
                List<TasksEntity> resultList = new List<TasksEntity>();
                this.property = new TasksProperty();

                DataSource<TasksEntity> datasource = connection.getDataSource<TasksEntity>();
                datasource.setProperty(property);

                Criteria c = new Criteria();

                c.where(ef.columnValue(property.toDate, date, "<="));
                c.where(ef.columnValue(property.statusId, "99", "<>"));//
                c.where(ef.columnValue(property.createdBy, currentIdentity.Name, "="));//쐬Җ{l
                c.orderBy(property.toDate, "DESC");
                resultList = datasource.find(c,associations);

                return resultList;
            }
            finally
            {
                this.disconnect();
            }

        }
        public List<TasksEntity> findByCondition(TaskSearchCondition condition)
        {
            List<TasksEntity> resultList = new List<TasksEntity>();

            try
            {
                this.connect("default");
                ExpressionFactory ef = connection.getExpressionFactory();

                Identity currentIdentity = (AuthProviderFactory.GetInstance()).GetIdentity();
                this.property = new TasksProperty();


                DataSource<TasksEntity> datasource = connection.getDataSource<TasksEntity>();
                datasource.setProperty(property);

                Criteria c = new Criteria();


                c.where(new ColumnValueCondition(property.createdBy, currentIdentity.Name, "="));//쐬Җ{l

                if (condition.periodFrom != null)
                {
                    c.where(ef.columnValue(property.toDate, condition.periodFrom, ">=", "@d1"));
                }
                if (condition.periodTo != null)
                {
                    c.where(ef.columnValue(property.toDate, condition.periodTo, "<=", "@d2"));
                }
                if (condition.categories.Count > 0)
                {
                    c.where(ef.columnValue(property.categoryId, condition.categories, "IN"));
                }
                if (condition.statuses.Count > 0)
                {
                    c.where(ef.columnValue(property.statusId, condition.statuses, "IN"));
                }
                if (condition.priorities.Count > 0)
                {
                    c.where(ef.columnValue(property.priority, condition.priorities, "IN"));
                }

                c.orderBy(property.toDate, "DESC");
                c.orderBy(property.statusId, "ASC");
                c.orderBy(property.id, "ASC");
                c.limit = 10;
                resultList = datasource.find(c, associations);
                return resultList;
            }
            finally
            {
                this.disconnect();
            }
        }
        public TasksEntity NewTask()
        {
            TasksEntity task = new TasksEntity();
            task.subject = "V^XN";
            task.fromDate = CFW.Util.DateUtil.Today();
            task.toDate = CFW.Util.DateUtil.Today();

            PrioritiesModel priorities = new PrioritiesModel();
            task.priority = priorities.getDefaultValue();

            StatusesModel statuses = new StatusesModel();
            task.statusId = statuses.getDefaultValue();
            return task;
        }
        public override int save(TasksEntity entity)
        {
            try
            {
                this.connect();
                AuthProvider auth = AuthProviderFactory.GetInstance();
                Identity id = auth.GetIdentity();
                if (entity.IsNew)
                {
                    entity.id = generateId();
                    entity.createdBy = id.Name;
                }
                entity.modifiedBy = id.Name;

                return base.save(entity);

            }
            finally
            {
                this.disconnect();
            }
        }
        private int generateId()
        {
            try
            {
                //save̒Ă΂̂ŁAconnection͊J
                Command generateIdCommand = new Command("select isnull( max(id) ,0) + 1 as newId from TASKS");
                generateIdCommand.SetConnection(this.connection);
                DataSet idSet = generateIdCommand.ExecuteQuery();
                int id = NumberUtil.Value<int>( idSet.Tables[0].Rows[0][0] );
                return id;
            }
            finally
            {

            }
        }
        public int generateRandom()
        {
            try
            {
                this.connect();
                AuthProvider auth = AuthProviderFactory.GetInstance();
                Identity authIdentity  = auth.GetIdentity();

                Random rnd = new Random();
                List<TasksEntity> entities = new List<TasksEntity>();
                for (int id = generateId(); id < 10000; id++)
                {
                    TasksEntity entity = new TasksEntity();
                    entity.id = id;
                    entity.subject = "^XN " + id.ToString("000000");
                    entity.priority =(byte) rnd.Next(3);
                    entity.statusId = (short) rnd.Next(5);
                    entity.categoryId = rnd.Next(5);
                    entity.fromDate = DateUtil.Today();
                    entity.fromDate.Value.AddDays(rnd.Next(100));

                    entity.toDate = DateUtil.Today();
                    entity.toDate.Value.AddDays(rnd.Next(100));

                    entity.createdBy = authIdentity.Name;
                    entity.modifiedBy = authIdentity.Name;
                    entity.IsNew = true;
                    entity.IsModified = true;
                    entities.Add(entity);
                }
                

                return base.save(entities);

            }
            finally
            {
                this.disconnect();
            }
        }

        public List<TasksEntity> findIncomleteAssoc(DateTime date)
        {
            List<TasksEntity> resultList = new List<TasksEntity>();
            try
            {
                this.connect("default");
                ExpressionFactory ef = connection.getExpressionFactory();

                Identity currentIdentity = (AuthProviderFactory.GetInstance()).GetIdentity();
                this.property = new TasksProperty();

                AssociationSelect<TasksEntity> select = new AssociationSelect<TasksEntity>(connection);
                select.from( new TasksProperty());
                select.associate(
                    new Association(
                        "category",
                        Association.Multiplicity.TO_ONE,
                        new CategoriesProperty(),
                        ef.strings("TASKS.CATEGORY_ID = CATEGORIES.ID")
                    ),
                    new Association(
                        "statuses", 
                        Association.Multiplicity.TO_ONE,
                        new StatusesProperty(),
                        ef.strings("TASKS.STATUS_ID = STATUSES.ID")
                    )

                );

                Criteria c = new Criteria();

                c.where(ef.columnValue(property.toDate, date, "<="));
                c.where(ef.columnValue(property.createdBy, currentIdentity.Name, "="));//쐬Җ{l
                c.where(ef.strings("STATUSES.CLOSED <> 1"));
                c.orderBy(property.toDate, "DESC");

                select.setCriteria(c);

                //ڕԂ
                resultList = select.queryAsEntity();

                return resultList;
            }
            finally
            {
                disconnect();
            }

        }
        public List<TasksEntity> findIncomlete(DateTime date)
        {
            List<TasksEntity> resultList = new List<TasksEntity>();
            try
            {
                this.connect("default");
                ExpressionFactory ef = connection.getExpressionFactory();

                Identity currentIdentity = (AuthProviderFactory.GetInstance()).GetIdentity();
                this.property = new TasksProperty();

                DataSource<TasksEntity> datasource = connection.getDataSource<TasksEntity>();
                datasource.setProperty(property);

                Criteria c = new Criteria();

                c.where(ef.columnValue(property.toDate, date, "<="));
                c.where(ef.strings("STATUSES.CLOSED <> 1"));//
                c.where(ef.columnValue(property.createdBy, currentIdentity.Name, "="));//쐬Җ{l
                c.orderBy(property.toDate, "DESC");
                resultList = datasource.find(c, associations);

                return resultList;


            }
            finally
            {
                disconnect();
            }

        }
        public List<TaskStatisticsEntity> findStatistics()
        {
            List<TaskStatisticsEntity> list = new List<TaskStatisticsEntity>();
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();
                SelectCommandBuilder builder = new SelectCommandBuilder(connection);
                builder.from("TASKS");
                builder.joinLeft("CATEGORIES", 
                    ef.relation("TASKS.CATEGORY_ID", "CATEGORIES.ID"), 
                    ef.strings("TASKS.DELETED = 0"), 
                    ef.strings("CATEGORIES.DELETED = 0"));
                builder.joinLeft("STATUSES", 
                    ef.relation("TASKS.STATUS_ID", "STATUSES.ID"), 
                    ef.strings("TASKS.DELETED = 0"), 
                    ef.strings("STATUSES.DELETED = 0"));
                builder.select("TASKS.CATEGORY_ID", "CATEGORY_ID");
                builder.select("TASKS.STATUS_ID", "STATUS_ID");
                builder.select("CATEGORIES.NAME", "CATEGORY_NAME");
                builder.select("STATUSES.NAME", "STATUS_NAME");
                builder.select("COUNT(*)", "NUM_TASKS");

                builder.where(ef.strings("STATUSES.CLOSED <> 1"));
                builder.where(ef.columnValue("TASKS.CREATED_BY", "m-okada", "=", "@userId"));

                builder.groupBy("TASKS.CATEGORY_ID");
                builder.groupBy("CATEGORIES.NAME");
                builder.groupBy("TASKS.STATUS_ID");
                builder.groupBy("STATUSES.NAME");

                builder.orderBy("TASKS.CATEGORY_ID");
                builder.orderBy("TASKS.STATUS_ID");

                builder.limit(100);
                Command command = builder.getCommand();
                DataSet result = command.ExecuteQuery();

                DataRowCollection rows = result.Tables[0].Rows;
                foreach (DataRow row in rows)
                {
                    TaskStatisticsEntity entity = new TaskStatisticsEntity();
                    entity.Map(row);
                    list.Add(entity);
                }


                return list;
            }
            finally
            {
                disconnect();
            }



        }
        public DataSet findAutoJoin()
        {
            AuthProvider auth = AuthProviderFactory.GetInstance();
            Identity currentId = auth.GetIdentity();

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            List<TasksEntity> list = new List<TasksEntity>();
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();

                TasksProperty p = new TasksProperty();
                AssociationSelect<TasksEntity> select = new AssociationSelect<TasksEntity>(connection);
                select.from(p);
                select.associate(
                    new Association(
                        "status", 
                        Association.Multiplicity.TO_ONE,
                        new StatusesProperty(),
                       ef.strings("TASKS.STATUS_ID = STATUSES.ID")
                    ),
                    new Association(
                        "categories", 
                        Association.Multiplicity.TO_ONE,
                        new CategoriesProperty(),
                        ef.strings("TASKS.CATEGORY_ID = CATEGORIES.ID")
                    )
                );

                Criteria c = new Criteria();
                c.where(ef.strings("STATUSES.CLOSED <> 1"));
                c.where(ef.columnValue("TASKS.CREATED_BY", currentId.Name, "=", "@userId"));


                c.orderBy("TASKS.CATEGORY_ID");
                c.orderBy("TASKS.STATUS_ID");
                c.orderBy("TASKS.ID");
                c.offset = 0;
                c.limit = 10;
                select.setCriteria(c);

                Command command = select.getCommand();
                DataSet result = command.ExecuteQuery();
                DataRowCollection rows = result.Tables[0].Rows;

                Type baseEntityType = typeof(TasksEntity);
                TasksEntity entity = null;

                foreach (DataRow row in rows)
                {
                    entity = new TasksEntity();
                    entity.Map(row, "TASKS");
                    entity.category = new CategoriesEntity();
                    entity.category.Map(row, "CATEGORIES");
                    StatusesEntity status = new StatusesEntity();
                    status.Map(row, "STATUSES");
                    entity.statuses.Add(status);

                }

                sw.Stop();
                System.Diagnostics.Debug.Write("elapsed: ");
                System.Diagnostics.Debug.WriteLine(sw.ElapsedMilliseconds.ToString());
                return result;
            }
            finally
            {
                disconnect();
            }



        }
    }

}