using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.Oracle.Models.Base
{
    /// <summary>
    /// table TASKS Field`
    /// </summary>
    [Serializable()]
    public class TasksTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[TASK_ID]</summary>
        protected decimal _taskId;
        ///<summary>[TASK_ID]</summary>
        public decimal taskId
        {
            get{return _taskId;}
            set{_taskId = value;}
        }
        ///<summary>[SUBJECT]</summary>
        protected string _subject;
        ///<summary>[SUBJECT]</summary>
        public string subject{
            get{return _subject;}
            set{_subject = value;}
        }
        ///<summary>[STATUS_ID]</summary>
        protected decimal _statusId;
        ///<summary>[STATUS_ID]</summary>
        public decimal statusId
        {
            get{return _statusId;}
            set{_statusId = value;}
        }
        ///<summary>[CATEGORY_ID]</summary>
        protected System.Nullable<decimal> _categoryId;
        ///<summary>[CATEGORY_ID]</summary>
        public System.Nullable<decimal> categoryId
        {
            get{return _categoryId;}
            set{_categoryId = value;}
        }
        ///<summary>[PRIORITY_ID]</summary>
        protected decimal _priorityId;
        ///<summary>[PRIORITY_ID]</summary>
        public decimal priorityId
        {
            get{return _priorityId;}
            set{_priorityId = value;}
        }
        ///<summary>[DESCRIPTION]</summary>
        protected string _description;
        ///<summary>[DESCRIPTION]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        ///<summary>[CREATED_BY]</summary>
        protected string _createdBy;
        ///<summary>[CREATED_BY]</summary>
        public string createdBy{
            get{return _createdBy;}
            set{_createdBy = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_BY]</summary>
        protected string _modifiedBy;
        ///<summary>[MODIFIED_BY]</summary>
        public string modifiedBy{
            get{return _modifiedBy;}
            set{_modifiedBy = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        ///<summary>[DELETED]</summary>
        protected decimal _deleted;
        ///<summary>[DELETED]</summary>
        public decimal deleted
        {
            get{return _deleted;}
            set{_deleted = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public TasksTableRow() : base()
        {
            this._taskId = 0;
            this._subject = "";
            this._statusId = 0;
            this._categoryId = null;
            this._priorityId = 0;
            this._description = "";
            this._createdBy = "system";
            this._createdAt = null;
            this._modifiedBy = "system";
            this._modifiedAt = null;
            this._deleted = 0;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if (name == "TASK_ID") { this._taskId = NumberUtil.Value<decimal>(value); return; }
            if(name ==  "SUBJECT"){ this._subject = StringUtil.StringValue( value );return; }
            if (name == "STATUS_ID") { this._statusId = NumberUtil.Value<decimal>(value); return; }
            if (name == "CATEGORY_ID") { this._categoryId = NumberUtil.Value<decimal?>(value); return; }
            if (name == "PRIORITY_ID") { this._priorityId = NumberUtil.Value<decimal>(value); return; }
            if(name ==  "DESCRIPTION"){ this._description = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_BY"){ this._createdBy = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_BY"){ this._modifiedBy = StringUtil.StringValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            if (name == "DELETED") { this._deleted = NumberUtil.Value<decimal>(value); return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "TASK_ID") return this._taskId;
            if(name ==  "SUBJECT") return this._subject;
            if(name ==  "STATUS_ID") return this._statusId;
            if(name ==  "CATEGORY_ID") return this._categoryId;
            if(name ==  "PRIORITY_ID") return this._priorityId;
            if(name ==  "DESCRIPTION") return this._description;
            if(name ==  "CREATED_BY") return this._createdBy;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_BY") return this._modifiedBy;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            if(name ==  "DELETED") return this._deleted;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            TasksTableRow clone = new TasksTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(TasksTableRow source)
        {
            this.taskId = source.taskId;
            this.subject = source.subject;
            this.statusId = source.statusId;
            this.categoryId = source.categoryId;
            this.priorityId = source.priorityId;
            this.description = source.description;
            this.createdBy = source.createdBy;
            this.createdAt = source.createdAt;
            this.modifiedBy = source.modifiedBy;
            this.modifiedAt = source.modifiedAt;
            this.deleted = source.deleted;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("TASK_ID")) { this._taskId = NumberUtil.Value<decimal>(row["TASK_ID"]); }
            if (cols.Contains("SUBJECT")){ this._subject = StringUtil.StringValue(row["SUBJECT"]); }
            if (cols.Contains("STATUS_ID")) { this._statusId = NumberUtil.Value<decimal>(row["STATUS_ID"]); }
            if (cols.Contains("CATEGORY_ID")) { this._categoryId = NumberUtil.Value<decimal?>(row["CATEGORY_ID"]); }
            if (cols.Contains("PRIORITY_ID")) { this._priorityId = NumberUtil.Value<decimal>(row["PRIORITY_ID"]); }
            if (cols.Contains("DESCRIPTION")){ this._description = StringUtil.StringValue(row["DESCRIPTION"]); }
            if (cols.Contains("CREATED_BY")){ this._createdBy = StringUtil.StringValue(row["CREATED_BY"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_BY")){ this._modifiedBy = StringUtil.StringValue(row["MODIFIED_BY"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            if (cols.Contains("DELETED")) { this._deleted = NumberUtil.Value<decimal>(row["DELETED"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "TASK_ID"); if (cols.Contains(columnName)) { this._taskId = NumberUtil.Value<decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "SUBJECT");if (cols.Contains(columnName)){ this._subject = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "STATUS_ID"); if (cols.Contains(columnName)) { this._statusId = NumberUtil.Value<decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "CATEGORY_ID"); if (cols.Contains(columnName)) { this._categoryId = NumberUtil.Value<decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "PRIORITY_ID"); if (cols.Contains(columnName)) { this._priorityId = NumberUtil.Value<decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "DESCRIPTION");if (cols.Contains(columnName)){ this._description = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_BY");if (cols.Contains(columnName)){ this._createdBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_BY");if (cols.Contains(columnName)){ this._modifiedBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED"); if (cols.Contains(columnName)) { this._deleted = NumberUtil.Value<decimal>(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._taskId = NumberUtil.Value<decimal>(reader[0]);
            this._subject = StringUtil.StringValue(reader[1]);
            this._statusId = NumberUtil.Value<decimal>(reader[2]);
            this._categoryId = NumberUtil.Value<decimal?>(reader[3]);
            this._priorityId = NumberUtil.Value<decimal>(reader[4]);
            this._description = StringUtil.StringValue(reader[5]);
            this._createdBy = StringUtil.StringValue(reader[6]);
            this._createdAt = DateUtil.DateValue(reader[7]);
            this._modifiedBy = StringUtil.StringValue(reader[8]);
            this._modifiedAt = DateUtil.DateValue(reader[9]);
            this._deleted = NumberUtil.Value<decimal>(reader[10]);
            
            this.IsNew = false;
        }
    }

}