using System;
using System.Collections.Generic;
using System.Text;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Validators;
using NUnit.Framework;

namespace CFW.Common.Test.Validator
{
    [TestFixture]
    public class DateFieldValidatorTest
    {
        /// <summary>
        /// K{tB[h,tH[}bg yyyy/MM/dd HH:mm:ss(ftHg)
        /// </summary>
        FieldProperty field1;
        /// <summary>
        /// K{tB[h,tH[}bg yyyy/MM/dd HH:mm:ss(ftHg)
        /// </summary>
        FieldProperty field2;
        /// <summary>
        /// K{tB[h,tH[}bg yyyy/MM/dd HH:mm:ss
        /// </summary>
        FieldProperty field3;
        /// <summary>
        /// K{tB[h,tH[}bg yyyy/MM/dd HH:mm
        /// </summary>
        FieldProperty field4;
        /// <summary>
        /// K{tB[h,tH[}bg yyyy/MM/dd
        /// </summary>
        FieldProperty field5;
        [NUnit.Framework.SetUp]
        public void init()
        {

            field1 = FieldProperty.NewInstance("datetime", "test_table", "field1", "[field1]", 16, 23, 3, false, null, false);
            field2 = FieldProperty.NewInstance("datetime", "test_table", "field1", "[field1]", 16, 23, 3, true, null, false);
            field3 = FieldProperty.NewInstance("datetime", "test_table", "field1", "[field1]", 16, 23, 3, true, null, false);
            (field3 as DateFieldProperty).Format = DateTimeOutputFormat.LONG_DATETIME;
            field4 = FieldProperty.NewInstance("datetime", "test_table", "field1", "[field1]", 16, 23, 3, true, null, false);
            (field4 as DateFieldProperty).Format = DateTimeOutputFormat.SMALL_DATETIME;
            field5 = FieldProperty.NewInstance("datetime", "test_table", "field1", "[field1]", 16, 23, 3, true, null, false);
            (field5 as DateFieldProperty).Format = DateTimeOutputFormat.LONG_DATE;
        }


        [NUnit.Framework.Test]
        public void TestRequired()
        {
            object dateObject = null;
            FieldValidator validator = FieldValidator.GetInstance(field1);

            bool result = validator.Validate(dateObject);
            Assert.IsFalse(result);

        }
        [NUnit.Framework.Test]
        public void TestNotRequired()
        {
            object dateObject = null;
            FieldValidator validator = FieldValidator.GetInstance(field2);

            bool result = validator.Validate(dateObject);
            Assert.IsTrue(result);

        }
        [NUnit.Framework.Test]
        public void TestFormatDefault()
        {
            object dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34:56");
            FieldValidator validator = FieldValidator.GetInstance(field1);

            bool result = validator.Validate(dateObject);
            Assert.IsTrue(result);

        }
        [NUnit.Framework.Test]
        public void TestFormatLongDateTime()
        {
            object dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34:56");
            FieldValidator validator = FieldValidator.GetInstance(field3);

            bool result = validator.Validate(dateObject);
            Assert.IsTrue(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34");
            result = validator.Validate(dateObject);
            Assert.IsTrue(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29");
            result = validator.Validate(dateObject);
            Assert.IsTrue(result);
        }
        [NUnit.Framework.Test]
        public void TestFormatSmallDateTime()
        {
            object dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34:56");
            FieldValidator validator = FieldValidator.GetInstance(field4);

            bool result = validator.Validate(dateObject);
            Assert.IsFalse(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34");
            result = validator.Validate(dateObject);
            Assert.IsTrue(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29");
            result = validator.Validate(dateObject);
            Assert.IsTrue(result);

        }
        [NUnit.Framework.Test]
        public void TestFormatDateOnly()
        {
            object dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34:56");
            FieldValidator validator = FieldValidator.GetInstance(field5);

            bool result = validator.Validate(dateObject);
            Assert.IsFalse(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29 12:34");
            result = validator.Validate(dateObject);
            Assert.IsFalse(result);

            dateObject = DateUtil.ParseLongDateTime("2012/2/29");
            result = validator.Validate(dateObject);
            Assert.IsTrue(result);

        }

    }
}
