using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using NUnit.Framework;
using CFW.Util;
using CFW.Database;
using CFW.FieldProperties;
using CFW.Validators;
using CFW.Forms.Filters;
using CFW.Windows.Forms.Adapters;

namespace CFW.Windows.Test.Forms.Input
{
    [NUnit.Framework.TestFixture]
    public class TextBoxElementTest
    {
        CFW.Sample.Table.TestTable3Table table;
        CFW.Sample.Table.TestTable3TableAccess access;
        CFW.Sample.Table.TestTable3TableProperties property;
        CFW.Sample.Table.TestTable3TableValidator validator;
        CFW.Database.Connection connection;

        [NUnit.Framework.SetUp]
        public void init()
        {
            connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            table = new CFW.Sample.Table.TestTable3Table();
            access = new CFW.Sample.Table.TestTable3TableAccess(connection);
            property = new CFW.Sample.Table.TestTable3TableProperties();
            validator = new CFW.Sample.Table.TestTable3TableValidator(table);
        }
        [NUnit.Framework.Test]
        public void StringField()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default, false),
                new StringFieldValidator(property.Field2));

            //
            textBox1.Text = "abcdefghijklmn";
            element.UpdateField();

            Assert.IsNotNull(element.GetValue());
            Assert.AreEqual("abcdefghijklmn", element.GetValue());

            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmn", textBox1.Text);


            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", textBox1.Text);

            //(ÕXy[X)
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "     abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ     ";
            element.UpdateField();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", textBox1.Text);

            //(^u>Xy[X)
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "     abcde\t\tfghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ     ";
            element.UpdateField();
            Assert.AreEqual("abcde  fghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("abcde  fghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ", textBox1.Text);

        }
        [NUnit.Framework.Test]
        public void StringField2()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default, true),
                new StringFieldValidator(property.Field2));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.IsNotNull(element.GetValue());
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMN", element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMN", textBox1.Text);


        }
        [NUnit.Framework.Test]
        public void StringField3()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default | StringUtil.NormalizeMode.ToUpper, true),
                new StringFieldValidator(property.Field2));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.IsNotNull(element.GetValue());
            Assert.AreEqual("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890ABCDEFGHIJKLMN", element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);

            element.Render();
            Assert.AreEqual("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890ABCDEFGHIJKLMN", textBox1.Text);
        }
        [NUnit.Framework.Test]
        public void StringField4()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default | StringUtil.NormalizeMode.ToLower, true),
                new StringFieldValidator(property.Field2));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.IsNotNull(element.GetValue());
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890abcdefghijklmn", element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyz1234567890abcdefghijklmn", textBox1.Text);
        }
        [NUnit.Framework.Test]
        public void StringField5()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default | StringUtil.NormalizeMode.ToAlpha, true),
                new StringFieldValidator(property.Field2));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.IsNotNull(element.GetValue());
            //               ----+----1----+----2----+----3----+----4----+----5
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWX", element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWX", textBox1.Text);
        }
        [NUnit.Framework.Test]
        public void StringField6()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new StringFilter(property.Field2, StringUtil.NormalizeMode.Default | StringUtil.NormalizeMode.ToDigit, true),
                new StringFieldValidator(property.Field2));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.IsNotNull(element.GetValue());
            Assert.AreEqual("1234567890", element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("1234567890", textBox1.Text);
        }
        [NUnit.Framework.Test(Description="ltB[h ͂ݏoAG[̂Ƃ0")]
        public void IntField1()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new NumberFilter<int>(property.Field1,true,true),
                new IntFieldValidator(property.Field1));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.AreEqual(1234567890, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("1234567890", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345678901";
            element.UpdateField();
            Assert.AreEqual(0, element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);//K{`FbNɈ
            element.Render();
            Assert.AreEqual("0", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345";
            element.UpdateField();
            Assert.AreEqual(12345, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("12345", textBox1.Text);
        }
        [NUnit.Framework.Test(Description = "ltB[h ͂ݏoAG[̂ƂG[")]
        public void IntField2()
        {
            TextBox textBox1 = new TextBox();
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new NumberFilter<int>(property.Field1, true, false),
                new IntFieldValidator(property.Field1));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.AreEqual(1234567890, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("1234567890", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345678901";
            element.UpdateField();
            Assert.AreEqual("2345678901", element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("2345678901", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345";
            element.UpdateField();
            Assert.AreEqual(12345, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("12345", textBox1.Text);
        }

        [NUnit.Framework.Test(Description = "ltB[h 0 ͂ݏoAG[̂Ƃ0")]
        public void IntField3()
        {
            TextBox textBox1 = new TextBox();
            property.Field1.AllowZero = true;
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new NumberFilter<int>(property.Field1, true, true),
                new IntFieldValidator(property.Field1));

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            element.UpdateField();
            Assert.AreEqual(1234567890, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("1234567890", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345678901";
            element.UpdateField();
            Assert.AreEqual(0, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);//K{`FbNɈȂ
            element.Render();
            Assert.AreEqual("0", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345";
            element.UpdateField();
            Assert.AreEqual(12345, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("12345", textBox1.Text);
        }
        [NUnit.Framework.Test(Description = "ttB[hAtłȂnull" )]
        public void DateField1()
        {
            TextBox textBox1 = new TextBox();
            property.Field1.AllowZero = true;
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new DateTimeFilter(CFW.DateTimeInputFormat.DATE_LONG,true),
                new DateFieldValidator(property.Field3),CFW.DateTimeOutputFormat.LONG_DATE);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "2001/2/3";
            element.UpdateField();
            Assert.AreEqual(DateTime.Parse("2001/2/3"), element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("2001/02/03", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "2002/2/30";
            element.UpdateField();
            Assert.AreEqual(null, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);//K{`FbNɈȂ
            element.Render();
            Assert.AreEqual("", textBox1.Text);

        }
        [NUnit.Framework.Test(Description = "ttB[hAtłȂ̃eLXg")]
        public void DateField2()
        {
            TextBox textBox1 = new TextBox();
            property.Field1.AllowZero = true;
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new DateTimeFilter(CFW.DateTimeInputFormat.DATE_LONG, false),
                new DateFieldValidator(property.Field3), CFW.DateTimeOutputFormat.LONG_DATE);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "2001/2/3";
            element.UpdateField();
            Assert.AreEqual(DateTime.Parse("2001/2/3"), element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("2001/02/03", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "2002/2/30";
            element.UpdateField();
            Assert.AreEqual("2002/2/30", element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);//K{`FbNɈȂ
            element.Render();
            Assert.AreEqual("2002/2/30", textBox1.Text);

        }

        [NUnit.Framework.Test(Description = "10itB[hA͂ݏoAG[̂Ƃ0")]
        public void DecimalField1()
        {
            TextBox textBox1 = new TextBox();
            property.Field1.AllowZero = true;
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new NumberFilter<decimal>(property.Field4,true,true),
                new DecimalFieldValidator(property.Field4), "#,##0.00");

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345678.91";
            element.UpdateField();
            Assert.AreEqual(12345678.91M, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("12,345,678.91", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "123456789.01";
            element.UpdateField();
            Assert.AreEqual(23456789.01M, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("23,456,789.01", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "123456789.012";
            element.UpdateField();
            Assert.AreEqual(23456789.01M, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("23,456,789.01", textBox1.Text);

        }
        [NUnit.Framework.Test(Description = "10itB[hA͂ݏoAG[̂Ƃ̂܂")]
        public void DecimalField2()
        {
            TextBox textBox1 = new TextBox();
            property.Field1.AllowZero = true;
            TextBoxAdapterElement element = new TextBoxAdapterElement(
                textBox1,
                new NumberFilter<decimal>(property.Field4, false, false),
                new DecimalFieldValidator(property.Field4), "#,##0.00");

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "12345678.91";
            element.UpdateField();
            Assert.AreEqual(12345678.91M, element.GetValue());
            element.Validate();
            Assert.IsTrue(element.IsValid);
            element.Render();
            Assert.AreEqual("12,345,678.91", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "123456789.01";
            element.UpdateField();
            Assert.AreEqual(123456789.01m, element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("123456789.01", textBox1.Text);

            //
            //               ----+----1----+----2----+----3----+----4----+----5
            textBox1.Text = "123456789.012";
            element.UpdateField();
            Assert.AreEqual(123456789.012M, element.GetValue());
            element.Validate();
            Assert.IsFalse(element.IsValid);
            element.Render();
            Assert.AreEqual("123456789.012", textBox1.Text);

        }
    }
}
