using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table Address Field`
    /// </summary>
    public class AddressTableFormAdapter : CFW.Forms.FormAdapter
	{
		private AddressTableRow theEntity;

		///<summary>[AddressID]</summary>
		public FormAdapterElement addressID;
		///<summary>[AddressLine1]</summary>
		public FormAdapterElement addressLine1;
		///<summary>[AddressLine2]</summary>
		public FormAdapterElement addressLine2;
		///<summary>[City]</summary>
		public FormAdapterElement city;
		///<summary>[PostalCode]</summary>
		public FormAdapterElement postalCode;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.addressID != null) this.addressID.Render();
			if(this.addressLine1 != null) this.addressLine1.Render();
			if(this.addressLine2 != null) this.addressLine2.Render();
			if(this.city != null) this.city.Render();
			if(this.postalCode != null) this.postalCode.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (AddressTableRow)entity;
			if(this.addressID != null) this.addressID.SetValue(this.theEntity.addressID);
			if(this.addressLine1 != null) this.addressLine1.SetValue(this.theEntity.addressLine1);
			if(this.addressLine2 != null) this.addressLine2.SetValue(this.theEntity.addressLine2);
			if(this.city != null) this.city.SetValue(this.theEntity.city);
			if(this.postalCode != null) this.postalCode.SetValue(this.theEntity.postalCode);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.addressID != null) this.theEntity.addressID = NumberUtil.Value<Int32>(this.addressID.GetValue());
			if(this.addressLine1 != null) this.theEntity.addressLine1 = StringUtil.StringValue(this.addressLine1.GetValue());
			if(this.addressLine2 != null) this.theEntity.addressLine2 = StringUtil.StringValue(this.addressLine2.GetValue());
			if(this.city != null) this.theEntity.city = StringUtil.StringValue(this.city.GetValue());
			if(this.postalCode != null) this.theEntity.postalCode = StringUtil.StringValue(this.postalCode.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.addressID != null) this.addressID.UpdateField();
			if(this.addressLine1 != null) this.addressLine1.UpdateField();
			if(this.addressLine2 != null) this.addressLine2.UpdateField();
			if(this.city != null) this.city.UpdateField();
			if(this.postalCode != null) this.postalCode.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.addressID != null){
			    if(!this.addressID.Validate()){
				    valid = false;
				    this.messages.Add(this.addressID.ErrorMessage);
			    }
			}
			
			if(this.addressLine1 != null){
			    if(!this.addressLine1.Validate()){
				    valid = false;
				    this.messages.Add(this.addressLine1.ErrorMessage);
			    }
			}
			
			if(this.addressLine2 != null){
			    if(!this.addressLine2.Validate()){
				    valid = false;
				    this.messages.Add(this.addressLine2.ErrorMessage);
			    }
			}
			
			if(this.city != null){
			    if(!this.city.Validate()){
				    valid = false;
				    this.messages.Add(this.city.ErrorMessage);
			    }
			}
			
			if(this.postalCode != null){
			    if(!this.postalCode.Validate()){
				    valid = false;
				    this.messages.Add(this.postalCode.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private AddressFormAdapter formAdapter;
    //     private AddressProperty property;
    //     private AddressEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new AddressFormAdapter();

	
    formAdapter.addressID= new TextBoxAdapterElement(
        addressID,
        new CFW.Forms.Filters.StringFilter(property.addressID),
        CFW.Validators.FieldValidator.GetInstance(property.addressID)
    );
	
    formAdapter.addressLine1= new TextBoxAdapterElement(
        addressLine1,
        new CFW.Forms.Filters.StringFilter(property.addressLine1),
        CFW.Validators.FieldValidator.GetInstance(property.addressLine1)
    );
	
    formAdapter.addressLine2= new TextBoxAdapterElement(
        addressLine2,
        new CFW.Forms.Filters.StringFilter(property.addressLine2),
        CFW.Validators.FieldValidator.GetInstance(property.addressLine2)
    );
	
    formAdapter.city= new TextBoxAdapterElement(
        city,
        new CFW.Forms.Filters.StringFilter(property.city),
        CFW.Validators.FieldValidator.GetInstance(property.city)
    );
	
    formAdapter.postalCode= new TextBoxAdapterElement(
        postalCode,
        new CFW.Forms.Filters.StringFilter(property.postalCode),
        CFW.Validators.FieldValidator.GetInstance(property.postalCode)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}