using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table ErrorLog Field`
    /// </summary>
    public class ErrorLogTableFormAdapter : CFW.Forms.FormAdapter
	{
		private ErrorLogTableRow theEntity;

		///<summary>Primary key for ErrorLog records.</summary>
		public FormAdapterElement errorLogID;
		///<summary>The date and time at which the error occurred.</summary>
		public FormAdapterElement errorTime;
		///<summary>The error number of the error that occurred.</summary>
		public FormAdapterElement errorNumber;
		///<summary>The severity of the error that occurred.</summary>
		public FormAdapterElement errorSeverity;
		///<summary>The state number of the error that occurred.</summary>
		public FormAdapterElement errorState;
		///<summary>The name of the stored procedure or trigger where the error occurred.</summary>
		public FormAdapterElement errorProcedure;
		///<summary>The line number at which the error occurred.</summary>
		public FormAdapterElement errorLine;
		///<summary>The message text of the error that occurred.</summary>
		public FormAdapterElement errorMessage;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.errorLogID != null) this.errorLogID.Render();
			if(this.errorTime != null) this.errorTime.Render();
			if(this.errorNumber != null) this.errorNumber.Render();
			if(this.errorSeverity != null) this.errorSeverity.Render();
			if(this.errorState != null) this.errorState.Render();
			if(this.errorProcedure != null) this.errorProcedure.Render();
			if(this.errorLine != null) this.errorLine.Render();
			if(this.errorMessage != null) this.errorMessage.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (ErrorLogTableRow)entity;
			if(this.errorLogID != null) this.errorLogID.SetValue(this.theEntity.errorLogID);
			if(this.errorTime != null) this.errorTime.SetValue(this.theEntity.errorTime);
			if(this.errorNumber != null) this.errorNumber.SetValue(this.theEntity.errorNumber);
			if(this.errorSeverity != null) this.errorSeverity.SetValue(this.theEntity.errorSeverity);
			if(this.errorState != null) this.errorState.SetValue(this.theEntity.errorState);
			if(this.errorProcedure != null) this.errorProcedure.SetValue(this.theEntity.errorProcedure);
			if(this.errorLine != null) this.errorLine.SetValue(this.theEntity.errorLine);
			if(this.errorMessage != null) this.errorMessage.SetValue(this.theEntity.errorMessage);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.errorLogID != null) this.theEntity.errorLogID = NumberUtil.Value<Int32>(this.errorLogID.GetValue());
			if(this.errorTime != null) this.theEntity.errorTime = DateUtil.DateValue(this.errorTime.GetValue());
			if(this.errorNumber != null) this.theEntity.errorNumber = NumberUtil.Value<Int32>(this.errorNumber.GetValue());
			if(this.errorSeverity != null) this.theEntity.errorSeverity = NumberUtil.Value<Int32?>(this.errorSeverity.GetValue());
			if(this.errorState != null) this.theEntity.errorState = NumberUtil.Value<Int32?>(this.errorState.GetValue());
			if(this.errorProcedure != null) this.theEntity.errorProcedure = StringUtil.StringValue(this.errorProcedure.GetValue());
			if(this.errorLine != null) this.theEntity.errorLine = NumberUtil.Value<Int32?>(this.errorLine.GetValue());
			if(this.errorMessage != null) this.theEntity.errorMessage = StringUtil.StringValue(this.errorMessage.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.errorLogID != null) this.errorLogID.UpdateField();
			if(this.errorTime != null) this.errorTime.UpdateField();
			if(this.errorNumber != null) this.errorNumber.UpdateField();
			if(this.errorSeverity != null) this.errorSeverity.UpdateField();
			if(this.errorState != null) this.errorState.UpdateField();
			if(this.errorProcedure != null) this.errorProcedure.UpdateField();
			if(this.errorLine != null) this.errorLine.UpdateField();
			if(this.errorMessage != null) this.errorMessage.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.errorLogID != null){
			    if(!this.errorLogID.Validate()){
				    valid = false;
				    this.messages.Add(this.errorLogID.ErrorMessage);
			    }
			}
			
			if(this.errorTime != null){
			    if(!this.errorTime.Validate()){
				    valid = false;
				    this.messages.Add(this.errorTime.ErrorMessage);
			    }
			}
			
			if(this.errorNumber != null){
			    if(!this.errorNumber.Validate()){
				    valid = false;
				    this.messages.Add(this.errorNumber.ErrorMessage);
			    }
			}
			
			if(this.errorSeverity != null){
			    if(!this.errorSeverity.Validate()){
				    valid = false;
				    this.messages.Add(this.errorSeverity.ErrorMessage);
			    }
			}
			
			if(this.errorState != null){
			    if(!this.errorState.Validate()){
				    valid = false;
				    this.messages.Add(this.errorState.ErrorMessage);
			    }
			}
			
			if(this.errorProcedure != null){
			    if(!this.errorProcedure.Validate()){
				    valid = false;
				    this.messages.Add(this.errorProcedure.ErrorMessage);
			    }
			}
			
			if(this.errorLine != null){
			    if(!this.errorLine.Validate()){
				    valid = false;
				    this.messages.Add(this.errorLine.ErrorMessage);
			    }
			}
			
			if(this.errorMessage != null){
			    if(!this.errorMessage.Validate()){
				    valid = false;
				    this.messages.Add(this.errorMessage.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private ErrorLogFormAdapter formAdapter;
    //     private ErrorLogProperty property;
    //     private ErrorLogEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new ErrorLogFormAdapter();

	
    formAdapter.errorLogID= new TextBoxAdapterElement(
        errorLogID,
        new CFW.Forms.Filters.StringFilter(property.errorLogID),
        CFW.Validators.FieldValidator.GetInstance(property.errorLogID)
    );
	
    formAdapter.errorTime= new TextBoxAdapterElement(
        errorTime,
        new CFW.Forms.Filters.StringFilter(property.errorTime),
        CFW.Validators.FieldValidator.GetInstance(property.errorTime)
    );
	
    formAdapter.errorNumber= new TextBoxAdapterElement(
        errorNumber,
        new CFW.Forms.Filters.StringFilter(property.errorNumber),
        CFW.Validators.FieldValidator.GetInstance(property.errorNumber)
    );
	
    formAdapter.errorSeverity= new TextBoxAdapterElement(
        errorSeverity,
        new CFW.Forms.Filters.StringFilter(property.errorSeverity),
        CFW.Validators.FieldValidator.GetInstance(property.errorSeverity)
    );
	
    formAdapter.errorState= new TextBoxAdapterElement(
        errorState,
        new CFW.Forms.Filters.StringFilter(property.errorState),
        CFW.Validators.FieldValidator.GetInstance(property.errorState)
    );
	
    formAdapter.errorProcedure= new TextBoxAdapterElement(
        errorProcedure,
        new CFW.Forms.Filters.StringFilter(property.errorProcedure),
        CFW.Validators.FieldValidator.GetInstance(property.errorProcedure)
    );
	
    formAdapter.errorLine= new TextBoxAdapterElement(
        errorLine,
        new CFW.Forms.Filters.StringFilter(property.errorLine),
        CFW.Validators.FieldValidator.GetInstance(property.errorLine)
    );
	
    formAdapter.errorMessage= new TextBoxAdapterElement(
        errorMessage,
        new CFW.Forms.Filters.StringFilter(property.errorMessage),
        CFW.Validators.FieldValidator.GetInstance(property.errorMessage)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}