using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table ProductCategory Field`
    /// </summary>
    public class ProductCategoryTableFormAdapter : CFW.Forms.FormAdapter
	{
		private ProductCategoryTableRow theEntity;

		///<summary>[ProductCategoryID]</summary>
		public FormAdapterElement productCategoryID;
		///<summary>[ParentProductCategoryID]</summary>
		public FormAdapterElement parentProductCategoryID;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.productCategoryID != null) this.productCategoryID.Render();
			if(this.parentProductCategoryID != null) this.parentProductCategoryID.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (ProductCategoryTableRow)entity;
			if(this.productCategoryID != null) this.productCategoryID.SetValue(this.theEntity.productCategoryID);
			if(this.parentProductCategoryID != null) this.parentProductCategoryID.SetValue(this.theEntity.parentProductCategoryID);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.productCategoryID != null) this.theEntity.productCategoryID = NumberUtil.Value<Int32>(this.productCategoryID.GetValue());
			if(this.parentProductCategoryID != null) this.theEntity.parentProductCategoryID = NumberUtil.Value<Int32?>(this.parentProductCategoryID.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.productCategoryID != null) this.productCategoryID.UpdateField();
			if(this.parentProductCategoryID != null) this.parentProductCategoryID.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.productCategoryID != null){
			    if(!this.productCategoryID.Validate()){
				    valid = false;
				    this.messages.Add(this.productCategoryID.ErrorMessage);
			    }
			}
			
			if(this.parentProductCategoryID != null){
			    if(!this.parentProductCategoryID.Validate()){
				    valid = false;
				    this.messages.Add(this.parentProductCategoryID.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private ProductCategoryFormAdapter formAdapter;
    //     private ProductCategoryProperty property;
    //     private ProductCategoryEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new ProductCategoryFormAdapter();

	
    formAdapter.productCategoryID= new TextBoxAdapterElement(
        productCategoryID,
        new CFW.Forms.Filters.StringFilter(property.productCategoryID),
        CFW.Validators.FieldValidator.GetInstance(property.productCategoryID)
    );
	
    formAdapter.parentProductCategoryID= new TextBoxAdapterElement(
        parentProductCategoryID,
        new CFW.Forms.Filters.StringFilter(property.parentProductCategoryID),
        CFW.Validators.FieldValidator.GetInstance(property.parentProductCategoryID)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}