using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table AddressɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class AddressTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[AddressID]</summary>
        public FieldProperty addressID;
        ///<summary>[AddressLine1]</summary>
        public FieldProperty addressLine1;
        ///<summary>[AddressLine2]</summary>
        public FieldProperty addressLine2;
        ///<summary>[City]</summary>
        public FieldProperty city;
        ///<summary>[PostalCode]</summary>
        public FieldProperty postalCode;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public AddressTableProperty()
        {
            this.EntityName = "Address";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            addressID = FieldProperty.NewInstance("int identity", "Address", "AddressID","[AddressID]", 4, 10, 0, false, 0,false);
            addressLine1 = FieldProperty.NewInstance("nvarchar", "Address", "AddressLine1","[AddressLine1]", 120, 60, 0, false, "",false);
            addressLine2 = FieldProperty.NewInstance("nvarchar", "Address", "AddressLine2","[AddressLine2]", 120, 60, 0, true, "",false);
            city = FieldProperty.NewInstance("nvarchar", "Address", "City","[City]", 60, 30, 0, false, "",false);
            postalCode = FieldProperty.NewInstance("nvarchar", "Address", "PostalCode","[PostalCode]", 30, 15, 0, false, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "Address", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.addressID;
            yield return this.addressLine1;
            yield return this.addressLine2;
            yield return this.city;
            yield return this.postalCode;
            yield return this.modifiedDate;
            
        }
                
    }
}