using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ErrorLog Field`
    /// </summary>
    [Serializable()]
    public class ErrorLogTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>Primary key for ErrorLog records.</summary>
        protected Int32 _errorLogID;
        ///<summary>Primary key for ErrorLog records.</summary>
        public Int32 errorLogID{
            get{return _errorLogID;}
            set{_errorLogID = value;}
        }
        ///<summary>The date and time at which the error occurred.</summary>
        protected DateTime? _errorTime;
        ///<summary>The date and time at which the error occurred.</summary>
        public DateTime? errorTime{
            get{return _errorTime;}
            set{_errorTime = value;}
        }
        ///<summary>The error number of the error that occurred.</summary>
        protected Int32 _errorNumber;
        ///<summary>The error number of the error that occurred.</summary>
        public Int32 errorNumber{
            get{return _errorNumber;}
            set{_errorNumber = value;}
        }
        ///<summary>The severity of the error that occurred.</summary>
        protected System.Nullable<Int32> _errorSeverity;
        ///<summary>The severity of the error that occurred.</summary>
        public System.Nullable<Int32> errorSeverity{
            get{return _errorSeverity;}
            set{_errorSeverity = value;}
        }
        ///<summary>The state number of the error that occurred.</summary>
        protected System.Nullable<Int32> _errorState;
        ///<summary>The state number of the error that occurred.</summary>
        public System.Nullable<Int32> errorState{
            get{return _errorState;}
            set{_errorState = value;}
        }
        ///<summary>The name of the stored procedure or trigger where the error occurred.</summary>
        protected string _errorProcedure;
        ///<summary>The name of the stored procedure or trigger where the error occurred.</summary>
        public string errorProcedure{
            get{return _errorProcedure;}
            set{_errorProcedure = value;}
        }
        ///<summary>The line number at which the error occurred.</summary>
        protected System.Nullable<Int32> _errorLine;
        ///<summary>The line number at which the error occurred.</summary>
        public System.Nullable<Int32> errorLine{
            get{return _errorLine;}
            set{_errorLine = value;}
        }
        ///<summary>The message text of the error that occurred.</summary>
        protected string _errorMessage;
        ///<summary>The message text of the error that occurred.</summary>
        public string errorMessage{
            get{return _errorMessage;}
            set{_errorMessage = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ErrorLogTableRow() : base()
        {
            this._errorLogID = 0;
            this._errorTime = null;
            this._errorNumber = 0;
            this._errorSeverity = null;
            this._errorState = null;
            this._errorProcedure = "";
            this._errorLine = null;
            this._errorMessage = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ErrorLogID"){ this._errorLogID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ErrorTime"){ this._errorTime = DateUtil.DateValue( value );return; }
            if(name ==  "ErrorNumber"){ this._errorNumber = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ErrorSeverity"){ this._errorSeverity = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ErrorState"){ this._errorState = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ErrorProcedure"){ this._errorProcedure = StringUtil.StringValue( value );return; }
            if(name ==  "ErrorLine"){ this._errorLine = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ErrorMessage"){ this._errorMessage = StringUtil.StringValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ErrorLogID") return this._errorLogID;
            if(name ==  "ErrorTime") return this._errorTime;
            if(name ==  "ErrorNumber") return this._errorNumber;
            if(name ==  "ErrorSeverity") return this._errorSeverity;
            if(name ==  "ErrorState") return this._errorState;
            if(name ==  "ErrorProcedure") return this._errorProcedure;
            if(name ==  "ErrorLine") return this._errorLine;
            if(name ==  "ErrorMessage") return this._errorMessage;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ErrorLogTableRow clone = new ErrorLogTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ErrorLogTableRow source)
        {
            this.errorLogID = source.errorLogID;
            this.errorTime = source.errorTime;
            this.errorNumber = source.errorNumber;
            this.errorSeverity = source.errorSeverity;
            this.errorState = source.errorState;
            this.errorProcedure = source.errorProcedure;
            this.errorLine = source.errorLine;
            this.errorMessage = source.errorMessage;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ErrorLogID")){ this._errorLogID = NumberUtil.Value<Int32>(row["ErrorLogID"]); }
            if (cols.Contains("ErrorTime")){ this._errorTime = DateUtil.DateValue(row["ErrorTime"]); }
            if (cols.Contains("ErrorNumber")){ this._errorNumber = NumberUtil.Value<Int32>(row["ErrorNumber"]); }
            if (cols.Contains("ErrorSeverity")){ this._errorSeverity = NumberUtil.Value<Int32?>(row["ErrorSeverity"]); }
            if (cols.Contains("ErrorState")){ this._errorState = NumberUtil.Value<Int32?>(row["ErrorState"]); }
            if (cols.Contains("ErrorProcedure")){ this._errorProcedure = StringUtil.StringValue(row["ErrorProcedure"]); }
            if (cols.Contains("ErrorLine")){ this._errorLine = NumberUtil.Value<Int32?>(row["ErrorLine"]); }
            if (cols.Contains("ErrorMessage")){ this._errorMessage = StringUtil.StringValue(row["ErrorMessage"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ErrorLogID");if (cols.Contains(columnName)){ this._errorLogID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorTime");if (cols.Contains(columnName)){ this._errorTime = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorNumber");if (cols.Contains(columnName)){ this._errorNumber = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorSeverity");if (cols.Contains(columnName)){ this._errorSeverity = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorState");if (cols.Contains(columnName)){ this._errorState = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorProcedure");if (cols.Contains(columnName)){ this._errorProcedure = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorLine");if (cols.Contains(columnName)){ this._errorLine = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ErrorMessage");if (cols.Contains(columnName)){ this._errorMessage = StringUtil.StringValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._errorLogID = NumberUtil.Value<Int32>(reader[0]);
            this._errorTime = DateUtil.DateValue(reader[1]);
            this._errorNumber = NumberUtil.Value<Int32>(reader[2]);
            this._errorSeverity = NumberUtil.Value<Int32?>(reader[3]);
            this._errorState = NumberUtil.Value<Int32?>(reader[4]);
            this._errorProcedure = StringUtil.StringValue(reader[5]);
            this._errorLine = NumberUtil.Value<Int32?>(reader[6]);
            this._errorMessage = StringUtil.StringValue(reader[7]);
            
            this.IsNew = false;
        }
    }

}