using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table SalesOrderDetailɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class SalesOrderDetailTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[SalesOrderID]</summary>
        public FieldProperty salesOrderID;
        ///<summary>[SalesOrderDetailID]</summary>
        public FieldProperty salesOrderDetailID;
        ///<summary>[OrderQty]</summary>
        public FieldProperty orderQty;
        ///<summary>[ProductID]</summary>
        public FieldProperty productID;
        ///<summary>[UnitPrice]</summary>
        public FieldProperty unitPrice;
        ///<summary>[UnitPriceDiscount]</summary>
        public FieldProperty unitPriceDiscount;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public SalesOrderDetailTableProperty()
        {
            this.EntityName = "SalesOrderDetail";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            salesOrderID = FieldProperty.NewInstance("int", "SalesOrderDetail", "SalesOrderID","[SalesOrderID]", 4, 10, 0, false, 0,false);
            salesOrderDetailID = FieldProperty.NewInstance("int identity", "SalesOrderDetail", "SalesOrderDetailID","[SalesOrderDetailID]", 4, 10, 0, false, 0,false);
            orderQty = FieldProperty.NewInstance("smallint", "SalesOrderDetail", "OrderQty","[OrderQty]", 2, 5, 0, false, 0,false);
            productID = FieldProperty.NewInstance("int", "SalesOrderDetail", "ProductID","[ProductID]", 4, 10, 0, false, 0,false);
            unitPrice = FieldProperty.NewInstance("money", "SalesOrderDetail", "UnitPrice","[UnitPrice]", 21, 19, 4, false, 0,false);
            unitPriceDiscount = FieldProperty.NewInstance("money", "SalesOrderDetail", "UnitPriceDiscount","[UnitPriceDiscount]", 21, 19, 4, false, 0.0,false);
            modifiedDate = FieldProperty.NewInstance("datetime", "SalesOrderDetail", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.salesOrderID;
            yield return this.salesOrderDetailID;
            yield return this.orderQty;
            yield return this.productID;
            yield return this.unitPrice;
            yield return this.unitPriceDiscount;
            yield return this.modifiedDate;
            
        }
                
    }
}