using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table SalesOrderHeaderɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class SalesOrderHeaderTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[SalesOrderID]</summary>
        public FieldProperty salesOrderID;
        ///<summary>[RevisionNumber]</summary>
        public FieldProperty revisionNumber;
        ///<summary>[OrderDate]</summary>
        public FieldProperty orderDate;
        ///<summary>[DueDate]</summary>
        public FieldProperty dueDate;
        ///<summary>[ShipDate]</summary>
        public FieldProperty shipDate;
        ///<summary>[Status]</summary>
        public FieldProperty status;
        ///<summary>[SalesOrderNumber]</summary>
        public FieldProperty salesOrderNumber;
        ///<summary>[CustomerID]</summary>
        public FieldProperty customerID;
        ///<summary>[ShipToAddressID]</summary>
        public FieldProperty shipToAddressID;
        ///<summary>[BillToAddressID]</summary>
        public FieldProperty billToAddressID;
        ///<summary>[ShipMethod]</summary>
        public FieldProperty shipMethod;
        ///<summary>[CreditCardApprovalCode]</summary>
        public FieldProperty creditCardApprovalCode;
        ///<summary>[SubTotal]</summary>
        public FieldProperty subTotal;
        ///<summary>[TaxAmt]</summary>
        public FieldProperty taxAmt;
        ///<summary>[Freight]</summary>
        public FieldProperty freight;
        ///<summary>[TotalDue]</summary>
        public FieldProperty totalDue;
        ///<summary>[Comment]</summary>
        public FieldProperty comment;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public SalesOrderHeaderTableProperty()
        {
            this.EntityName = "SalesOrderHeader";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            salesOrderID = FieldProperty.NewInstance("int identity", "SalesOrderHeader", "SalesOrderID","[SalesOrderID]", 4, 10, 0, false, 0,false);
            revisionNumber = FieldProperty.NewInstance("tinyint", "SalesOrderHeader", "RevisionNumber","[RevisionNumber]", 1, 3, 0, false, 0,false);
            orderDate = FieldProperty.NewInstance("datetime", "SalesOrderHeader", "OrderDate","[OrderDate]", 16, 23, 3, false, null,false);
            dueDate = FieldProperty.NewInstance("datetime", "SalesOrderHeader", "DueDate","[DueDate]", 16, 23, 3, false, null,false);
            shipDate = FieldProperty.NewInstance("datetime", "SalesOrderHeader", "ShipDate","[ShipDate]", 16, 23, 3, true, null,false);
            status = FieldProperty.NewInstance("tinyint", "SalesOrderHeader", "Status","[Status]", 1, 3, 0, false, 1,false);
            salesOrderNumber = FieldProperty.NewInstance("nvarchar", "SalesOrderHeader", "SalesOrderNumber","[SalesOrderNumber]", 50, 25, 0, false, "",false);
            customerID = FieldProperty.NewInstance("int", "SalesOrderHeader", "CustomerID","[CustomerID]", 4, 10, 0, false, 0,false);
            shipToAddressID = FieldProperty.NewInstance("int", "SalesOrderHeader", "ShipToAddressID","[ShipToAddressID]", 4, 10, 0, true, null,false);
            billToAddressID = FieldProperty.NewInstance("int", "SalesOrderHeader", "BillToAddressID","[BillToAddressID]", 4, 10, 0, true, null,false);
            shipMethod = FieldProperty.NewInstance("nvarchar", "SalesOrderHeader", "ShipMethod","[ShipMethod]", 100, 50, 0, false, "",false);
            creditCardApprovalCode = FieldProperty.NewInstance("varchar", "SalesOrderHeader", "CreditCardApprovalCode","[CreditCardApprovalCode]", 15, 15, 0, true, "",false);
            subTotal = FieldProperty.NewInstance("money", "SalesOrderHeader", "SubTotal","[SubTotal]", 21, 19, 4, false, 0.00,false);
            taxAmt = FieldProperty.NewInstance("money", "SalesOrderHeader", "TaxAmt","[TaxAmt]", 21, 19, 4, false, 0.00,false);
            freight = FieldProperty.NewInstance("money", "SalesOrderHeader", "Freight","[Freight]", 21, 19, 4, false, 0.00,false);
            totalDue = FieldProperty.NewInstance("money", "SalesOrderHeader", "TotalDue","[TotalDue]", 21, 19, 4, false, 0,false);
            comment = FieldProperty.NewInstance("ntext", "SalesOrderHeader", "Comment","[Comment]", 2147483646, 1073741823, 0, true, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "SalesOrderHeader", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.salesOrderID;
            yield return this.revisionNumber;
            yield return this.orderDate;
            yield return this.dueDate;
            yield return this.shipDate;
            yield return this.status;
            yield return this.salesOrderNumber;
            yield return this.customerID;
            yield return this.shipToAddressID;
            yield return this.billToAddressID;
            yield return this.shipMethod;
            yield return this.creditCardApprovalCode;
            yield return this.subTotal;
            yield return this.taxAmt;
            yield return this.freight;
            yield return this.totalDue;
            yield return this.comment;
            yield return this.modifiedDate;
            
        }
                
    }
}