using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Model;
using CFW.Sample.Model.TableRow;

namespace CFW.Sample.Model.TableProperty
{
    /// <summary>
    /// table MAST_SITEɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class MastSiteTableProperty : CFW.Models.EntityProperty
    {
		///<summary>[SITE_CODE]</summary>
		public FieldProperty SiteCode;
		///<summary>[OPEN_DATE]</summary>
		public FieldProperty OpenDate;
		///<summary>[CLOSE_DATE]</summary>
		public FieldProperty CloseDate;
		///<summary>[SORT_SEQ]</summary>
		public FieldProperty SortSeq;
		///<summary>[NAME]</summary>
		public FieldProperty Name;
		///<summary>[ANK_NAME]</summary>
		public FieldProperty AnkName;
		///<summary>[COMPANY_CODE]</summary>
		public FieldProperty CompanyCode;
		///<summary>[SITE_URL]</summary>
		public FieldProperty SiteUrl;
		///<summary>[SITE_URL_OTHER]</summary>
		public FieldProperty SiteUrlOther;
		///<summary>[SITE_CATEGORY1]</summary>
		public FieldProperty SiteCategory1;
		///<summary>[SITE_CATEGORY2]</summary>
		public FieldProperty SiteCategory2;
		///<summary>[DEVICE_CODE]</summary>
		public FieldProperty DeviceCode;
		///<summary>[MENU_DEVICE_CODE]</summary>
		public FieldProperty MenuDeviceCode;
		///<summary>[MENU_ADTYPE_CODE]</summary>
		public FieldProperty MenuAdtypeCode;
		///<summary>[GOODS_CATEGORY_CODE]</summary>
		public FieldProperty GoodsCategoryCode;
		///<summary>[CARRIER_CODE1]</summary>
		public FieldProperty CarrierCode1;
		///<summary>[CARRIER_CODE2]</summary>
		public FieldProperty CarrierCode2;
		///<summary>[CARRIER_CODE3]</summary>
		public FieldProperty CarrierCode3;
		///<summary>[CARRIER_CODE4]</summary>
		public FieldProperty CarrierCode4;
		///<summary>[MEDIA_COST_RATE]</summary>
		public FieldProperty MediaCostRate;
		///<summary>[AGENCY_MARGIN_RATE]</summary>
		public FieldProperty AgencyMarginRate;
		///<summary>[SP_OPEN_FLAG]</summary>
		public FieldProperty SpOpenFlag;
		///<summary>[PM_OPEN_FLAG]</summary>
		public FieldProperty PmOpenFlag;
		///<summary>[IO_OPEN_FLAG]</summary>
		public FieldProperty IoOpenFlag;
		///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
		public FieldProperty AdGuideOpenFlag;
		///<summary>[IMPRESSION]</summary>
		public FieldProperty Impression;
		///<summary>[IMPRESSION_TERM]</summary>
		public FieldProperty ImpressionTerm;
		///<summary>[IMPRESSION_TOPPAGE]</summary>
		public FieldProperty ImpressionToppage;
		///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
		public FieldProperty ImpressionToppageTerm;
		///<summary>[UNIQUE_USER]</summary>
		public FieldProperty UniqueUser;
		///<summary>[UNIQUE_USER_TERM]</summary>
		public FieldProperty UniqueUserTerm;
		///<summary>[UNIQUE_USER_TOPPAGE]</summary>
		public FieldProperty UniqueUserToppage;
		///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
		public FieldProperty UniqueUserToppageTerm;
		///<summary>[MALE_RATE]</summary>
		public FieldProperty MaleRate;
		///<summary>[FEMALE_RATE]</summary>
		public FieldProperty FemaleRate;
		///<summary>[PUBLISHED_YEAR]</summary>
		public FieldProperty PublishedYear;
		///<summary>[PUBLISHED_MONTH]</summary>
		public FieldProperty PublishedMonth;
		///<summary>[PUBLISHED_DAY]</summary>
		public FieldProperty PublishedDay;
		///<summary>[PUBLISHED_DATA_KIND]</summary>
		public FieldProperty PublishedDataKind;
		///<summary>[UPPER_SITE_CODE]</summary>
		public FieldProperty UpperSiteCode;
		///<summary>[PAYMENT_COMPANY]</summary>
		public FieldProperty PaymentCompany;
		///<summary>[BUSINESS_DIRECT_FLAG]</summary>
		public FieldProperty BusinessDirectFlag;
		///<summary>[ADSERVER_FLAG]</summary>
		public FieldProperty AdserverFlag;
		///<summary>[SPECIALMENU_FLAG]</summary>
		public FieldProperty SpecialmenuFlag;
		///<summary>[TOP_OPEN_FLAG]</summary>
		public FieldProperty TopOpenFlag;
		///<summary>[OPEN_MENU_COUNT]</summary>
		public FieldProperty OpenMenuCount;
		///<summary>[MAKE_DATE]</summary>
		public FieldProperty MakeDate;
		///<summary>[DOCUMENT_ADDRESS]</summary>
		public FieldProperty DocumentAddress;
		///<summary>[AG_COMPANY_CODE]</summary>
		public FieldProperty AgCompanyCode;
		///<summary>[INSIDE_OPEN_LEVEL]</summary>
		public FieldProperty InsideOpenLevel;
		///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
		public FieldProperty OutsideOpenLevel;
		///<summary>[HOME_RATE]</summary>
		public FieldProperty HomeRate;
		///<summary>[WORK_RATE]</summary>
		public FieldProperty WorkRate;
		///<summary>[OVERLAP_RATE]</summary>
		public FieldProperty OverlapRate;
		///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
		public FieldProperty BusinessRepDirectFlag;
		///<summary>[CLIENT_SITE_FLAG]</summary>
		public FieldProperty ClientSiteFlag;
		///<summary>[PRINT_UPPER_SITE_CODE]</summary>
		public FieldProperty PrintUpperSiteCode;
		///<summary>[TEAM_CODE]</summary>
		public FieldProperty TeamCode;
		///<summary>[CHECK_NAME]</summary>
		public FieldProperty CheckName;
		///<summary>[VALID_FLAG]</summary>
		public FieldProperty ValidFlag;
		///<summary>[INSERT_DATE_TIME]</summary>
		public FieldProperty InsertDateTime;
		///<summary>[INSERT_OPERATOR_CODE]</summary>
		public FieldProperty InsertOperatorCode;
		///<summary>[UPDATE_DATE_TIME]</summary>
		public FieldProperty UpdateDateTime;
		///<summary>[OPERATOR_CODE]</summary>
		public FieldProperty OperatorCode;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public MastSiteTableProperty()
        {
        	this.EntityName = "MAST_SITE";
			SiteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_CODE","[SITE_CODE]", 5, 0, 0, false, "",true);
			OpenDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "OPEN_DATE","[OPEN_DATE]", 8, 0, 0, false, "",false);
			CloseDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "CLOSE_DATE","[CLOSE_DATE]", 8, 0, 0, true, "",false);
			SortSeq = FieldProperty.NewInstance("smallint", "MAST_SITE", "SORT_SEQ","[SORT_SEQ]", 2, 5, 0, true, 0,false);
			Name = FieldProperty.NewInstance("varchar", "MAST_SITE", "NAME","[NAME]", 100, 0, 0, false, "",false);
			AnkName = FieldProperty.NewInstance("varchar", "MAST_SITE", "ANK_NAME","[ANK_NAME]", 100, 0, 0, false, "",false);
			CompanyCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "COMPANY_CODE","[COMPANY_CODE]", 4, 0, 0, true, "",false);
			SiteUrl = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_URL","[SITE_URL]", 100, 0, 0, true, "",false);
			SiteUrlOther = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_URL_OTHER","[SITE_URL_OTHER]", 100, 0, 0, true, "",false);
			SiteCategory1 = FieldProperty.NewInstance("smallint", "MAST_SITE", "SITE_CATEGORY1","[SITE_CATEGORY1]", 2, 5, 0, true, 0,false);
			SiteCategory2 = FieldProperty.NewInstance("smallint", "MAST_SITE", "SITE_CATEGORY2","[SITE_CATEGORY2]", 2, 5, 0, true, 0,false);
			DeviceCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "DEVICE_CODE","[DEVICE_CODE]", 2, 5, 0, false, 0,false);
			MenuDeviceCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "MENU_DEVICE_CODE","[MENU_DEVICE_CODE]", 2, 5, 0, true, 0,false);
			MenuAdtypeCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "MENU_ADTYPE_CODE","[MENU_ADTYPE_CODE]", 2, 5, 0, true, 0,false);
			GoodsCategoryCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "GOODS_CATEGORY_CODE","[GOODS_CATEGORY_CODE]", 2, 5, 0, true, 0,false);
			CarrierCode1 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE1","[CARRIER_CODE1]", 2, 5, 0, true, 0,false);
			CarrierCode2 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE2","[CARRIER_CODE2]", 2, 5, 0, true, 0,false);
			CarrierCode3 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE3","[CARRIER_CODE3]", 2, 5, 0, true, 0,false);
			CarrierCode4 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE4","[CARRIER_CODE4]", 2, 5, 0, true, 0,false);
			MediaCostRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "MEDIA_COST_RATE","[MEDIA_COST_RATE]", 7, 5, 2, true, 0,false);
			AgencyMarginRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "AGENCY_MARGIN_RATE","[AGENCY_MARGIN_RATE]", 7, 5, 2, true, 0,false);
			SpOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "SP_OPEN_FLAG","[SP_OPEN_FLAG]", 2, 5, 0, true, 1,false);
			PmOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "PM_OPEN_FLAG","[PM_OPEN_FLAG]", 2, 5, 0, true, 1,false);
			IoOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "IO_OPEN_FLAG","[IO_OPEN_FLAG]", 2, 5, 0, true, 0,false);
			AdGuideOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "AD_GUIDE_OPEN_FLAG","[AD_GUIDE_OPEN_FLAG]", 2, 5, 0, true, 1,false);
			Impression = FieldProperty.NewInstance("decimal", "MAST_SITE", "IMPRESSION","[IMPRESSION]", 14, 12, 0, true, 0,false);
			ImpressionTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "IMPRESSION_TERM","[IMPRESSION_TERM]", 2, 5, 0, true, 0,false);
			ImpressionToppage = FieldProperty.NewInstance("decimal", "MAST_SITE", "IMPRESSION_TOPPAGE","[IMPRESSION_TOPPAGE]", 14, 12, 0, true, 0,false);
			ImpressionToppageTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "IMPRESSION_TOPPAGE_TERM","[IMPRESSION_TOPPAGE_TERM]", 2, 5, 0, true, 0,false);
			UniqueUser = FieldProperty.NewInstance("decimal", "MAST_SITE", "UNIQUE_USER","[UNIQUE_USER]", 14, 12, 0, true, 0,false);
			UniqueUserTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "UNIQUE_USER_TERM","[UNIQUE_USER_TERM]", 2, 5, 0, true, 0,false);
			UniqueUserToppage = FieldProperty.NewInstance("decimal", "MAST_SITE", "UNIQUE_USER_TOPPAGE","[UNIQUE_USER_TOPPAGE]", 20, 18, 0, true, 0,false);
			UniqueUserToppageTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "UNIQUE_USER_TOPPAGE_TERM","[UNIQUE_USER_TOPPAGE_TERM]", 2, 5, 0, true, 0,false);
			MaleRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "MALE_RATE","[MALE_RATE]", 7, 5, 2, true, 0,false);
			FemaleRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "FEMALE_RATE","[FEMALE_RATE]", 7, 5, 2, true, 0,false);
			PublishedYear = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_YEAR","[PUBLISHED_YEAR]", 2, 5, 0, true, 0,false);
			PublishedMonth = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_MONTH","[PUBLISHED_MONTH]", 2, 5, 0, true, 0,false);
			PublishedDay = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_DAY","[PUBLISHED_DAY]", 2, 5, 0, true, 0,false);
			PublishedDataKind = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_DATA_KIND","[PUBLISHED_DATA_KIND]", 2, 5, 0, true, 0,false);
			UpperSiteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "UPPER_SITE_CODE","[UPPER_SITE_CODE]", 5, 0, 0, true, "",false);
			PaymentCompany = FieldProperty.NewInstance("varchar", "MAST_SITE", "PAYMENT_COMPANY","[PAYMENT_COMPANY]", 4, 0, 0, true, "",false);
			BusinessDirectFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "BUSINESS_DIRECT_FLAG","[BUSINESS_DIRECT_FLAG]", 2, 5, 0, true, 0,false);
			AdserverFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "ADSERVER_FLAG","[ADSERVER_FLAG]", 2, 5, 0, true, 0,false);
			SpecialmenuFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "SPECIALMENU_FLAG","[SPECIALMENU_FLAG]", 2, 5, 0, true, 0,false);
			TopOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "TOP_OPEN_FLAG","[TOP_OPEN_FLAG]", 2, 5, 0, true, 0,false);
			OpenMenuCount = FieldProperty.NewInstance("smallint", "MAST_SITE", "OPEN_MENU_COUNT","[OPEN_MENU_COUNT]", 2, 5, 0, true, 0,false);
			MakeDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "MAKE_DATE","[MAKE_DATE]", 8, 0, 0, true, "",false);
			DocumentAddress = FieldProperty.NewInstance("varchar", "MAST_SITE", "DOCUMENT_ADDRESS","[DOCUMENT_ADDRESS]", 100, 0, 0, true, "",false);
			AgCompanyCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "AG_COMPANY_CODE","[AG_COMPANY_CODE]", 4, 0, 0, true, "",false);
			InsideOpenLevel = FieldProperty.NewInstance("smallint", "MAST_SITE", "INSIDE_OPEN_LEVEL","[INSIDE_OPEN_LEVEL]", 2, 5, 0, true, 1,false);
			OutsideOpenLevel = FieldProperty.NewInstance("smallint", "MAST_SITE", "OUTSIDE_OPEN_LEVEL","[OUTSIDE_OPEN_LEVEL]", 2, 5, 0, true, 1,false);
			HomeRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "HOME_RATE","[HOME_RATE]", 7, 5, 2, true, 0,false);
			WorkRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "WORK_RATE","[WORK_RATE]", 7, 5, 2, true, 0,false);
			OverlapRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "OVERLAP_RATE","[OVERLAP_RATE]", 7, 5, 2, true, 0,false);
			BusinessRepDirectFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "BUSINESS_REP_DIRECT_FLAG","[BUSINESS_REP_DIRECT_FLAG]", 2, 5, 0, true, 0,false);
			ClientSiteFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "CLIENT_SITE_FLAG","[CLIENT_SITE_FLAG]", 2, 5, 0, true, 0,false);
			PrintUpperSiteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "PRINT_UPPER_SITE_CODE","[PRINT_UPPER_SITE_CODE]", 5, 0, 0, true, "",false);
			TeamCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "TEAM_CODE","[TEAM_CODE]", 2, 5, 0, true, 0,false);
			CheckName = FieldProperty.NewInstance("varchar", "MAST_SITE", "CHECK_NAME","[CHECK_NAME]", 100, 0, 0, true, "",false);
			ValidFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "VALID_FLAG","[VALID_FLAG]", 2, 5, 0, true, 1,false);
			InsertDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_SITE", "INSERT_DATE_TIME","[INSERT_DATE_TIME]", 16, 16, 0, true, null,false);
			InsertOperatorCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "INSERT_OPERATOR_CODE","[INSERT_OPERATOR_CODE]", 6, 0, 0, true, "",false);
			UpdateDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_SITE", "UPDATE_DATE_TIME","[UPDATE_DATE_TIME]", 16, 16, 0, true, null,false);
			OperatorCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "OPERATOR_CODE","[OPERATOR_CODE]", 6, 0, 0, true, "",false);
			
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerator<FieldProperty> GetFields()
        {
			yield return this.SiteCode;
			yield return this.OpenDate;
			yield return this.CloseDate;
			yield return this.SortSeq;
			yield return this.Name;
			yield return this.AnkName;
			yield return this.CompanyCode;
			yield return this.SiteUrl;
			yield return this.SiteUrlOther;
			yield return this.SiteCategory1;
			yield return this.SiteCategory2;
			yield return this.DeviceCode;
			yield return this.MenuDeviceCode;
			yield return this.MenuAdtypeCode;
			yield return this.GoodsCategoryCode;
			yield return this.CarrierCode1;
			yield return this.CarrierCode2;
			yield return this.CarrierCode3;
			yield return this.CarrierCode4;
			yield return this.MediaCostRate;
			yield return this.AgencyMarginRate;
			yield return this.SpOpenFlag;
			yield return this.PmOpenFlag;
			yield return this.IoOpenFlag;
			yield return this.AdGuideOpenFlag;
			yield return this.Impression;
			yield return this.ImpressionTerm;
			yield return this.ImpressionToppage;
			yield return this.ImpressionToppageTerm;
			yield return this.UniqueUser;
			yield return this.UniqueUserTerm;
			yield return this.UniqueUserToppage;
			yield return this.UniqueUserToppageTerm;
			yield return this.MaleRate;
			yield return this.FemaleRate;
			yield return this.PublishedYear;
			yield return this.PublishedMonth;
			yield return this.PublishedDay;
			yield return this.PublishedDataKind;
			yield return this.UpperSiteCode;
			yield return this.PaymentCompany;
			yield return this.BusinessDirectFlag;
			yield return this.AdserverFlag;
			yield return this.SpecialmenuFlag;
			yield return this.TopOpenFlag;
			yield return this.OpenMenuCount;
			yield return this.MakeDate;
			yield return this.DocumentAddress;
			yield return this.AgCompanyCode;
			yield return this.InsideOpenLevel;
			yield return this.OutsideOpenLevel;
			yield return this.HomeRate;
			yield return this.WorkRate;
			yield return this.OverlapRate;
			yield return this.BusinessRepDirectFlag;
			yield return this.ClientSiteFlag;
			yield return this.PrintUpperSiteCode;
			yield return this.TeamCode;
			yield return this.CheckName;
			yield return this.ValidFlag;
			yield return this.InsertDateTime;
			yield return this.InsertOperatorCode;
			yield return this.UpdateDateTime;
			yield return this.OperatorCode;
			
        }
        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerator<FieldProperty> GetPrimaryKeys()
        {
            yield return  this.SiteCode;
            
        }
    }
}