﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using CFW.Util;
using CFW.Auth;
using CFW.Acl;


public partial class auth_AutoLoginTest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        AuthProvider provider = AuthProviderFactory.GetInstance();
        if (provider.IsAuthenticated())
        {
            StringBuilder builder = new StringBuilder();
            Identity id = provider.GetIdentity();
            builder.Append(id.User.Id);
            builder.Append(" ");
            builder.Append(id.User.Name);
            builder.Append(" ");
            builder.Append(Environment.NewLine);
            foreach (IAclRole role in id.Roles)
            {
                builder.Append(role.name);
                builder.Append(" ");
                builder.Append(Environment.NewLine);
            }
            Label1.Text = StringUtil.HtmlSafe(builder.ToString()).Replace(Environment.NewLine, "<br />");

        }
        else
        {
            Label1.Text = "not logged in";
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        CFW.Web.Auth.Authentication auth = new CFW.Web.Auth.Authentication();
        auth.LogOut();
        FormsAuthentication.RedirectToLoginPage();
    }
}
