using System;
using System.Collections.Generic;
using System.Text;

using CFW.Util;
using CFW.FieldProperties;
using CFW.Validators;
using CFW.Forms;
using CFW.Forms.Filters;

namespace WindowsApplicationSample1.FormAdapterTest
{
    class GcTextFormAdapter : FormAdapter
    {
        StringEntity entity;

        public FormAdapterElement element1;
        public FormAdapterElement element2;
        public FormAdapterElement element3;
        public FormAdapterElement element4;


        public override bool Validate()
        {
            bool valid = true;
            if (!this.element1.Validate()) valid = false;
            if (!this.element2.Validate()) valid = false;
            if (!this.element3.Validate()) valid = false;
            if (!this.element4.Validate()) valid = false;

            this.isValid = valid;
            return valid;
        }

        public override void UpdateFields()
        {

            this.element1.UpdateField();
            this.element2.UpdateField();
            this.element3.UpdateField();
            this.element4.UpdateField();
        }

        public override void SetEntity(CFW.Models.Entity dataSource)
        {
            this.entity = dataSource as StringEntity;

            this.element1.SetValue(this.entity.Field1);
            this.element2.SetValue(this.entity.Field2);
            this.element3.SetValue(this.entity.Field3);
            this.element4.SetValue(this.entity.Field4);
        }

        public override CFW.Models.Entity GetEntity()
        {
            return this.entity;
        }

        public override void UpdateEntity()
        {
            this.entity.Field1 = StringUtil.StringValue( this.element1.GetValue() );
            this.entity.Field2 = StringUtil.StringValue(this.element2.GetValue());
            this.entity.Field3 = StringUtil.StringValue(this.element3.GetValue());
            this.entity.Field4 = StringUtil.StringValue(this.element4.GetValue());
        }

        public override void RenderView()
        {
            this.element1.Render();
            this.element2.Render();
            this.element3.Render();
            this.element4.Render();
        }
    }
}
