using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Common;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using CFW.Database;
using CFW.Database.Conditions;
using CFW.Sample.Models;
using C1.Win.C1FlexGrid;
namespace WindowsApplicationSample1
{
    public partial class SampleGrid : Form
    {
        public SampleGrid()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            DataSource<MastMenuEntity> datasource = new DataSource<MastMenuEntity>();
            MastMenuProperty property = new MastMenuProperty();
            datasource.connect();
            datasource.setProperty(property);
            Criteria c = new Criteria();
            c.AddWhere(new ColumnValueCondition(property.siteCode,textBox1.Text + "%","LIKE"));

            List<MastMenuEntity> list = datasource.find(c);

            datasource.disconnect();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms," + list.Count.ToString() + "";
            initGrid();
            sw.Reset();
            sw.Start();
            c1FlexGrid1.DataSource = list;
            c1FlexGrid1.Refresh();
            sw.Stop();
            label1.Text += "grid refresh "  + sw.ElapsedMilliseconds.ToString("#,##0") + "ms";

        }
        private void initGrid()
        {
            clearColumns(c1FlexGrid1);
            addColumn(c1FlexGrid1, "siteCode", "SITE_CODE","");
            addColumn(c1FlexGrid1, "menuCode", "MENU_CODE","");
            addColumn(c1FlexGrid1, "name", "NAME","");
            addColumn(c1FlexGrid1, "updateDateTime", "UPDATE","yyyy/MM/dd HH:mm");
            addColumn(c1FlexGrid1, "operatorCode", "OPERATOR","");

        }
        public  void addColumn(C1FlexGrid grid, string name, string label, string format)
        {
            Column c = grid.Cols.Add();
            c.Name = name;
            c.Caption = label;
            c.Format = format;
        }
        public void clearColumns(C1FlexGrid grid)
        {
            int numCols = grid.Cols.Count;
            if (numCols > 1)
            {
                grid.Cols.RemoveRange(1, numCols - 1);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            Command command = new Command("select * from mast_menu where site_code like @site_code");
            command.SetParameter(new Parameter("@site_code",textBox1.Text + "%"));
            DataSet result = connection.ExecuteQuery(command);
            connection.Close();

            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms," + result.Tables[0].Rows.Count.ToString() + "";
            initGrid2();
            sw.Reset();
            sw.Start();
            c1FlexGrid1.DataSource = result.Tables[0];
            c1FlexGrid1.Refresh();
            sw.Stop();
            label1.Text += "grid refresh " + sw.ElapsedMilliseconds.ToString("#,##0") + "ms";

        }
        private void initGrid2()
        {
            clearColumns(c1FlexGrid1);
            addColumn(c1FlexGrid1, "SITE_CODE", "SITE_CODE", "");
            addColumn(c1FlexGrid1, "MENU_CODE", "MENU_CODE", "");
            addColumn(c1FlexGrid1, "NAME", "NAME", "");
            addColumn(c1FlexGrid1, "UPDATE_DATE_TIME", "UPDATE", "yyyy/MM/dd HH:mm");
            addColumn(c1FlexGrid1, "OPERATOR_CODE", "OPERATOR", "");

        }

        private void button3_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            Command command = new Command("select * from mast_menu where site_code like @site_code");
            command.SetParameter(new Parameter("@site_code", textBox1.Text + "%"));
            DataSet result = connection.ExecuteQuery(command);
            connection.Close();

            List<MastMenuEntity> list = new List<MastMenuEntity>();
            DataRowCollection rows = result.Tables[0].Rows;
            for (int r = 0; r < rows.Count; r++)
            {
                MastMenuEntity entity = new MastMenuEntity();
                entity.Map(rows[r]);
                list.Add(entity);
            }

            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms," + result.Tables[0].Rows.Count.ToString() + "";
            initGrid();
            sw.Reset();
            sw.Start();
            c1FlexGrid1.DataSource = list;
            c1FlexGrid1.Refresh();
            sw.Stop();
            label1.Text += "grid refresh " + sw.ElapsedMilliseconds.ToString("#,##0") + "ms";

        }

        private void button4_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            Command command = new Command("select * from mast_menu where site_code like @site_code");
            command.SetParameter(new Parameter("@site_code", textBox1.Text + "%"));
            DbDataReader reader = connection.ExecuteReader(command);

            List<MastMenuEntity> list = new List<MastMenuEntity>();
            while(reader.Read())
            {
                MastMenuEntity entity = new MastMenuEntity();
                entity.Map2(reader);
                list.Add(entity);
            }
            connection.Close();

            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0") + "ms," + list.Count.ToString() + "";
            initGrid();
            sw.Reset();
            sw.Start();
            c1FlexGrid1.DataSource = list;
            c1FlexGrid1.Refresh();
            sw.Stop();
            label1.Text += "grid refresh " + sw.ElapsedMilliseconds.ToString("#,##0") + "ms";

        }
    }
}