// VacationHome.cs
using System;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;

[assembly: WebResource("SampleControl.JScript1.js", "text/javascript", PerformSubstitution = true)]
namespace Samples.AspNet.CS.Controls
{
    [
    AspNetHostingPermission(SecurityAction.InheritanceDemand,
        Level = AspNetHostingPermissionLevel.Minimal),
    AspNetHostingPermission(SecurityAction.Demand,
        Level = AspNetHostingPermissionLevel.Minimal),
    Designer(typeof(YuiModuleDesigner)),
    DefaultProperty("Title"),
    ToolboxData(
        "<{0}:YuiPanel runat=\"server\"> </{0}:YuiPanel>"),
    ]
    public class YuiPanel : YuiOverlay
    {
        [
        Category("Display"),
        DefaultValue(true),
        Description("Closable")
        ]
        public virtual bool Closable
        {
            get
            {
                return (ViewState["Closable"] == null ? true : (bool)ViewState["Closable"]);
            }
            set
            {
                ViewState["Closable"] = value;
            }
        }
        [
        Category("Display"),
        DefaultValue(true),
        Description("Draggable")
        ]
        public virtual bool Draggable
        {
            get
            {
                return (ViewState["Draggable"] == null ? true : (bool)ViewState["Draggable"]);
            }
            set
            {
                ViewState["Draggable"] = value;
            }
        }
        [
        Category("Display"),
        DefaultValue(true),
        Description("Modal")
        ]
        public virtual bool Modal
        {
            get
            {
                return (ViewState["Modal"] == null ? true : (bool)ViewState["Modal"]);
            }
            set
            {
                ViewState["Modal"] = value;
            }
        }
        public enum Underlays
        {
            Shadow,
            Matte,
            None
        }
        [
        Category("Display"),
        DefaultValue(Underlays.Shadow),
        Description("Underlay")
        ]
        public virtual Underlays Underlay
        {
            get
            {
                return (ViewState["Underlay"] == null ? Underlays.Shadow : (Underlays)ViewState["Underlay"]);
            }
            set
            {
                ViewState["Underlay"] = value;
            }
        }
        protected string[] UnderlayString = { "shadow", "matte", "none" };


        public override string YuiClassName
        {
            get
            {
                return "YAHOO.widget.Panel";
            }
        }
        protected override void BuildConfigurationElements(System.IO.StringWriter writer)
        {
            base.BuildConfigurationElements(writer);
            writer.Write(",close:" + (Closable ? "true" : "false"));
            writer.Write(",draggable:" + (Draggable ? "true" : "false"));
            writer.Write(",modal:" + (Modal ? "true" : "false"));
            writer.Write(",underlay:\"" + UnderlayString[(int)Underlay] + "\"");

        }
    }

}