<?php
/**
 * MYSQL用データベース接続
 * @author okada
 *
 */
class CFW_Database_Connection_Mysql extends CFW_Database_AbstractConnection{
	public function __construct($config){
	    parent::__construct($config);
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#_createDSN()
	 */
	function _createDSN(){
	   $dsn = $this->config->driver . ":";
	   $dsn .= "host=".$this->config->params->host . ";";	
       $dsn .= "dbname=".$this->config->params->dbname . ";";   
       $dsn .= "port=".$this->config->params->port. ";";
       $dsn .= "charset=".$this->config->params->charset. ";";
       return $dsn;
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#quote()
	 */
	public function quote($val,$type = CFW_Model_DataTypes::VARCHAR){
		$result = "";
	   	if($type == CFW_Model_DataTypes::INTEGER){
	   		$result = strval(intval($val));
	   	}
	   	else if($type == CFW_Model_DataTypes::FLOAT){
            $result = strval(floatval($val));
	   	}
        else{
            $result = $this->_connection->quote($val); 
        }
        return $result;
        
	   	 
	}
	public function escape($val){
	    
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#encode()
	 */
	public function encode($val){
        return $val;
		
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#decode()
	 */
	public function decode($val){
		return $val;
	}

	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#encodeVariables()
	 */
    public function encodeVariables(&$variables){
        return true;
    }
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractConnection#decodeVariables()
     */
    public function decodeVariables(&$variables){
        return true;
    }
    
}
?>