<?php
include( "../core.php" );

/**
 * 再帰下降型
 * Tokenizerを使う
 * 結果をExpressionオブジェクトのかたまりにする
 * 個々の要素の展開は個々のクラスが実行
 * BNF
 * Expr = Term { + Term }
 * Term = Fact { * Fact }
 * Fact = ( Expr ) | number
 * @author okada
 */


/**
 * 足し算
 * @author okada
 *
 */
class Expression{
    var $terms;

    public function __construct(){
        $this->terms = array();
    }
    public function parse(&$tokenizer){
        $term = new Term();
        
        $this->terms[] = $term->parse($tokenizer); //最初のterm
        
        while ($tokenizer->token == '+') {
            $tokenizer->nextToken();
              
            $term = new Term();
            $this->terms[] = $term->parse($tokenizer);
        }
        return $this;
        
    }
    function dump(){
        $s = "";
        foreach($this->terms as $term){
            if($s != "") $s .= " + "; 
            $s .= $term->dump();
        }
        return  " ( " . $s  . " ) ";
    }
}
/**
 * 掛け算
 * @author okada
 *
 */
class Term{
    var $facts;

    public function __construct(){
        $this->facts = array();
    }
    function parse(&$tokenizer) {
        $fact = new Fact();
        $this->facts[] = $fact->parse($tokenizer); //最初のterm
        while ($tokenizer->token == '*') {
            $tokenizer->nextToken();

            
            $fact = new Fact();
            $this->facts[] = $fact->parse($tokenizer);
            
        }
        return $this;
    }
    
    function dump(){
        $s = "";
        foreach($this->facts as $fact){
            if($s != "") $s .= " * "; 
            $s .= $fact->dump();
        }
        return " " . $s . " ";
    }
}
class Fact{
    var $expr;
    public function parse(&$tokenizer) {
        if ($tokenizer->token == '(') {
            $tokenizer->nextToken();
            
            $expr = new Expression();
            $this->expr = $expr->parse($tokenizer);
            $tokenizer->nextToken(); //skip last ")"
            return $this;
        }
        else{
            $result = new Number();
            $this->expr = $result->parse($tokenizer);
            return $this;
        }
    }
    
    function dump(){
        return  $this->expr->dump();
    }
    
}
class Number{
    var $num;
    public function parse(&$tokenizer) {
            $value = 0;
            $n = intval($tokenizer->token);
            $this->num = $n;
            $tokenizer->nextToken(); //skip last ")"
            
            return $this;
    }
    function dump(){
        return " " .$this->num . " ";
    }
}

class Parser{
    var $result;
    var $tokenizer;
    var $currentToken ;
    function __construct(){
    }
    public function parse($s){
        $this->tokenizer = new CFW_Common_Tokenizer(new CFW_IO_StringReader( $s ));
        $this->currentToken = $this->tokenizer->nextToken();
        $expr = new Expression();
        $this->result = $expr->parse($this->tokenizer);
        
    }
    
    
    
}

$parser = new Parser();
$parser->parse("1 + 2 * 3 + 4 * 5 + 5 + 6 + 7");
echo "-----<br />";
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("2 * (3 + 4) + 11"); // = 25
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("2 * ((3 + 4) * 5) + 11"); // = 25
echo "result = " . $parser->result->dump(). "<br />";

echo "-----<br />";
$parser->parse("2 * 3 + 4 * 5"); // = 25
echo "result = " . $parser->result->dump(). "<br />";

?>