<?php
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_Condition");
class CFW_Data_Criteria_ComplexCondition extends CFW_Data_Criteria_Condition{
        var $_conditions;
        var $_modifier;
        var $_parameters;

        public function __construct($modifier = CFW_Data_Criteria::OPERATOR_NONE)
        {
            parent::__construct();
            $this->_conditions = array();
            $this->modifier = $modifier;
            $this->_parameters = array();
        }
        public function add($condition,$operator = CFW_Data_Criteria::OPERATOR_AND){
            if( count($this->_conditions ) > 0){
                $this->_conditions[] = $operator;
            }
            $this->_conditions[] = $condition;
            $this->_parameters = array_merge($this->_parameters,$condition->getParameters());
        }
        public function addAnd($condition){
            $this->add($condition,CFW_Data_Criteria::OPERATOR_AND);
        }
        public function addOr($condition){
            $this->add($condition,CFW_Data_Criteria::OPERATOR_OR);
        }

        public function buildExpression(){
            $expression = "";
            if($this->modifier != CFW_Data_Criteria::OPERATOR_NONE){
                $expression .= $this->modifier . " ";
            }

            $expression .= "(";
            foreach( $this->_conditions as $condition ){
                if(is_string( $condition )){
                    $expression .= " " . $condition . " ";
                }
                else if($condition instanceof  CFW_Data_Criteria_Condition){
                    $expression .= "(" .  $condition->buildExpression() . ")";
                }
            }
            $expression .= ")";
            return $expression;
        }
        public function getParameters(){
            return $this->_parameters;
        }


}