<?php
/**
 * 問い合わせ条件
 * @author okada
 *
 */
abstract class CFW_Model_Criteria{
    /**
     * 条件追加
     * 
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
	public abstract function add($expr,$param = null,$op = "=");
	/**
	 * AND条件追加
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
	 * @return unknown_type
	 */
    public abstract function addAnd($expr,$param = null,$op = "=");
    /**
     * OR条件追加
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
    public abstract function addOr($expr,$param = null,$op = "=");
	
}
?>