<?php
/**
 * DBクエリー実行コマンド
 * @author okada
 *
 */
class CFW_Database_Command{
    /**
     * 実行するクエリー「
     * @var unknown_type
     */
    var $query;
    /**
     * 実行時のパラメータ
     * @var unknown_type
     */
    var $params;
    /**
     * 接続先
     * @var unknown_type
     */
    var $connection;
    /**
     * ステートメントオブジェクト
     * 
     * 実際にクエリーを実行するPDO_Statementのオブhじぇ句と
     * @var unknown_type
     */
    var $_stmt;
	/**
	 * 構築
	 * @param string $query 実行するクエリー
	 * @return unknown_type
	 */
	public function __construct($query){
		 $this->query = $query;
		 $this->params = array(); 
	}
	/**
	 * 既に存在するDB接続を設定する
	 * @param $con
	 * @return unknown_type
	 */
	public function setConnection($con){
	   $this->connection = $con;	
	}
	/**
	 * 問い合わせ（Select) 実行
	 * 
	 * SELECT問い合わせを実行しDataTableを作成する
	 * @return unknown_type
	 */
	public function executeQuery(){
	    $this->_stmt = $this->connection->_connection->prepare($this->query);
	    $this->_bindParameters();
        $this->_stmt->execute();
        $con = $this->connection;
        $dataSet = new CFW_Model_DataTable();
        while($row = $this->_stmt->fetch(PDO::FETCH_ASSOC)){
            $con->decodeVariables($row);
            $dataRow = $dataSet->newRow();
            $dataRow->_row = $row;
            $dataRow->_state = CFW_Model_DataRow::STATE_UNCHANGED;
            $dataSet->rows[] = $dataRow;
        }
        
        return $dataSet;
	   
	}
	/**
	 * 二次元データテーブルにデータを詰める
	 * @param CFW_Data_DataTable $table
	 * @return unknown_type
	 */
	public function fill(&$table){
        $this->_stmt = $this->connection->_connection->prepare($this->query);
        $this->_bindParameters();
        $this->_stmt->execute();
        $con = $this->connection;

        while($row = $this->_stmt->fetch(PDO::FETCH_ASSOC)){
            $con->decodeVariables($row);
            $dataRow = $table->newRow();
            $dataRow->_row = $row;
            $dataRow->_state = CFW_Model_DataRow::STATE_UNCHANGED;
            $dataRow->table = $table->table;
            $table->rows[] = $dataRow;  
        }
        
        return true;
       
	    
	}
	/**
	 * 問い合わせ（Select) 実行
	 * 
	 * 問い合わせ（Select) 実行を実行し、前方カーソルっぽいReaderを返す
	 * @return unknown_type
	 */
    public function executeReader(){
        $this->_stmt = $this->connection->_connection->prepare($this->query);
        $this->_bindParameters();
        $this->_stmt->execute();
               
       $reader = new CFW_Database_Reader();
       $reader->stmt = $this->_stmt;
       $reader->connection = $this->connection;
        return $reader;
       
    }
    /**
     * 更新クエリーを実行する
     * @return unknown_type
     */
	public function executeUpdate(){
        $this->_stmt = $this->connection->_connection->prepare($this->query);
        $this->_bindParameters();
        $result = $this->_stmt->execute();
	    
        return $result;
		
	}
	/**
	 * パラメータを追加する
	 * 
	 * @param $name
	 * @param $value
	 * @param $type
	 * @param $length
	 * @return unknown_type
	 */
	public function addParameter($name,$value = null,$type = CFW_Model_DataTypes::VARCHAR,$length = 0){
        $this->params[$name] = array( "value" => $value,"type" => $type,"length" =>$length);
		 
	}
	/**
	 * パラメータを追加する
	 * 
	 * 既に作成されているパラメータの配列を追加する「 
	 * @param array $params
	 * @return unknown_type
	 */
    public function addParameters($params){
        $this->params = array_merge($this->params,$params);
         
    }
    /**
     * パラメータを設定する。
     * 
     * パラメータを設定する。特に追加済みのパラメータを置き換える
     * @param $name
     * @param $value
     * @param $type
     * @param $length
     * @return unknown_type
     */
	public function setParameter($name,$value = null,$type = CFW_Model_DataTypes::VARCHAR,$length = 0){
        $this->params[$name] = array("value" => $value,"type" => $type,"length" =>$length);
		
	}
	/**
	 * パラメータをステートメントオブジェクトにバインド
	 * @return unknown_type
	 */
	function _bindParameters(){
        foreach($this->params as $name => $param){
            if(is_array($param)){
                $this->_stmt->bindValue($name, $this->connection->encode( $param["value"] ));
                
            }
            else{
                $this->_stmt->bindValue($name, $this->connection->encode( $param ));
                
            }
        }
	    
		
	}
}
?>