<?php
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_Condition");
/**
 * 複合検索条件
 * @author okada
 * @package CFW_Data_Criteria
 */
class CFW_Data_Criteria_ComplexCondition extends CFW_Data_Criteria_Condition{
        var $_conditions;
        var $_modifier;
        var $_parameters;

        /**
         * 構築
         * @param unknown_type $modifier
         * @return unknown_type
         */
        public function __construct($modifier = CFW_Data_Criteria::OPERATOR_NONE)
        {
            parent::__construct();
            $this->_conditions = array();
            $this->modifier = $modifier;
            $this->_parameters = array();
        }
        /**
         * 条件追加
         * @param unknown_type $condition
         * @param unknown_type $operator
         * @return unknown_type
         */
        public function add($condition,$operator = CFW_Data_Criteria::OPERATOR_AND){
            if( count($this->_conditions ) > 0){
                $this->_conditions[] = $operator;
            }
            $this->_conditions[] = $condition;
            $this->_parameters = array_merge($this->_parameters,$condition->getParameters());
        }
        /**
         * 条件をANDで追加
         * @param unknown_type $condition
         * @return unknown_type
         */
        public function addAnd($condition){
            $this->add($condition,CFW_Data_Criteria::OPERATOR_AND);
        }
        /**
         * 条件をORで追加
         * @param unknown_type $condition
         * @return unknown_type
         */
        public function addOr($condition){
            $this->add($condition,CFW_Data_Criteria::OPERATOR_OR);
        }

        /* (non-PHPdoc)
         * @see library/CFW/Data/Criteria/CFW_Data_Criteria_Condition#buildExpression()
         */
        public function buildExpression(){
            $expression = "";
            if($this->modifier != CFW_Data_Criteria::OPERATOR_NONE){
                $expression .= $this->modifier . " ";
            }

            $expression .= "(";
            foreach( $this->_conditions as $condition ){
                if(is_string( $condition )){
                    $expression .= " " . $condition . " ";
                }
                else if($condition instanceof  CFW_Data_Criteria_Condition){
                    $expression .= "(" .  $condition->buildExpression() . ")";
                }
            }
            $expression .= ")";
            return $expression;
        }
        /**
         * (non-PHPdoc)
         * @see library/CFW/Data/Criteria/CFW_Data_Criteria_Condition#getParameters()
         */
        public function getParameters(){
            return $this->_parameters;
        }


}