<?php
/**
 * 各種関数
 * @author okada
 * @package CFW_Util
 */
class CFW_Util_Util{
	/**
	 * 配列をつなげて文字列にする。
	 * @param $arr 対象の配列
	 * @param $delimiter 分離記号
	 * @param $quoter 引用符をつけるための関数
	 * @return Sring
	 */
	public static function arrayToString($arr,$delimiter = ",",$quoter = null){
		$str = "";
		foreach($arr as $item){
			if($str != "") $str .= $delimiter;
			if($quoter === null) $el = $item;
			else 	$el = call_user_func_array($quoter,array($item));
			$str .= $el;
		}
		return $str;
	}
	/**
	 * 引用符を付ける
	 * @param $str 対象文字列
	 * @param $quoteSimbol 引用符
	 * @return String
	 */
	public static function q($str,$quoteSimbol = "'"){
		return $quoteSimbol.$str.$quoteSimbol;
	}
	/**
	 * alias for htmlspecialchars
	 * @param $str
	 * @param $enc
	 * @return String
	 */
	public static function escape($str,$enc = null){
		if($enc === null) $enc = mb_internal_encoding();
		return htmlspecialchars($str,ENT_QUOTES,$enc);
	}
	/**
	 * Alias for escape
	 * @param $str
	 * @param $enc
	 * @return String
	 */
    public static function h($str,$enc = null){
        return self::escape($str,$enc);
    }
    /**
     * javascript用エスケープ
     * @param $str
     * @return String
     */
	public static function jsescape($str){
	    $result = "";
	    $len = mb_strlen($str);
	    for($i = 0 ; $i < $len;$i++){
	        $c = mb_substr($str,$i,1);
	        if($c == "\\" ||$c == "\"" ||$c == ">"  ){
	            $result .= "\\" . $c;
	        }
	        else if ($c == '\b')
	            $result .="\\b";
	        else if ($c == '\t')
	            $result .="\\t";
	        else if ($c == '\n')
	            $result .="\\n";
	        else if ($c == '\f')
	            $result .= "\\f";
	        else if ($c == '\r')
	            $result .="\\r";
	        else
	        {
	            if (ord($c) < 0x20)
	            {

	            }
	            else{
	                $result .= $c;

	            }
	        }

	    }
	    return $result;
	}
	/**
	 * javascript用引用符付き文字列
	 * @param $str
	 * @return String
	 */
	public static function jsquote($str){
		return "\"" . self::jsescape($str) . "\"";
	}
	/**
	 * alias for jsquote
	 * @param $str
	 * @return String
	 */
    public static function jq($str){
		return self::jsquote($str);
	}
	/**
	 * 文字列化
	 * @param $val
	 * @return String
	 *
	 */
	public static function toString($val){
		return "".$val;
	}
	/**
	 * 整数化
	 * @param $val
	 * @return int
	 */
	public static function toInteger($val){
		if($val == null) return 0;
		return intval($val);
	}
	/**
	 * 浮動小数点化
	 * @param $val
	 * @return float
	 */
	public static function toFloat($val){
		if($val == null) return 0.0;
		return floatval($val);
	}
	/**
	 * 日付化
	 * @param $val
	 * @return DateTime
	 */
	public static function toDate($val){
		if($val == null) return null;
		return new DateTime($val);

	}




}