<?php
/**
 * LDAP Criteria 解析
 * 
 * BNF
 * <logical_expression> ::= <expression>
 * <expression> ::= <term> [ "|" <term>]
 * <term> ::= <factor> [ "&" <factor> ] 
 * <factor> ::= ( <logical_expression> ) | <relative_expression>
 * <relative_operator> ::= = | ~= | >= | <=
 * <logical_operator> ::= "|" | "&" 
 * 
 *
 */

include("../../core.php");

class Element{
    var $modifier;
    
}
class OperatorElement extends Element{
    const OP_AND = "&";
    const OP_OR = "|";
    const OP_NOT = "!";
    const OP_EQ = "=";
    const OP_EQR = "~=";
    const OP_GE = ">=";
    const OP_LE = "<=";
    
    var $op;
    
    public function __construct($op){
        $this->op = $op;
    }
    
}
class ExpressionElement extends Element{
    var $expr;
    
    public function __construct($expr){
        $this->expr = $expr;
    }
}
class ComplexElement extends Element{
    var $expr;
    public function __construct($expr){
        $this->expr = $expr;
    }
}

class Expression{
    var $terms;
    var $modifier;
    
    public function __construct(){
        $this->terms= array();
    }
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();

        $term = new Term();
        $this->terms[] = $term->parse($iterator);                
    
        while(true){
            if(!$iterator->valid()) break;
            $element = $iterator->current();
            if($element instanceof OperatorElement){
                if($element->op !== OperatorElement::OP_OR){
                    break;
                }
                
            }
            $iterator->next();
            if(!$iterator->valid()) break;
            $element = $iterator->current();
            $term = new Term();
            $this->terms[] = $term->parse($iterator);                
        }
        
        return $this;
        
    }
    public function dump(){
        if(count($this->terms) == 1){
            $term = $this->terms[0];
            return  $term->dump() ;
            
        }
        else if(count($this->terms) > 1){
            $s = "|";
            foreach($this->terms as $term){
                $s .=  $term->dump() ;
            }
            return "(" . $s .")";
            
        }
        
    }
}
class Term{
    var $facts;

    public function __construct(){
        $this->facts = array();
    }
    public function parse(ArrayIterator &$iterator){
        $fact = new Factor();
        $this->facts[] = $fact->parse($iterator); //最初のterm
        while (true) {
            if(!$iterator->valid()) break;
            $element = $iterator->current();
            if($element instanceof OperatorElement){
                if($element->op !== OperatorElement::OP_AND){
                    break;
                }
                
            }
            
            $iterator->next();
            if(!$iterator->valid()) break;
            
            $fact = new Factor();
            $this->facts[] = $fact->parse($iterator);
            
        }
        return $this;
        
    }
    public function dump(){
        if(count($this->facts) == 1){
            return $this->facts[0]->dump();
            
        }
        else if(count($this->facts) > 1){
            $s = "&";
            foreach($this->facts as $fact){
                $s .=  $fact->dump() ;
            }
            return "(" .$s . ")";
            
        }
    }
}
class Factor{
    var $expr;
    
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        if ($element instanceof ComplexElement) {
            
            $expr = new Expression();
            $it = new ArrayIterator(new ArrayObject($element->expr));
            $this->expr = $expr->parse($iterator);
            return $this;
        }
        else{
            $result = new RelativeCondition();
            $this->expr = $result->parse($iterator);
            return $this;
        }
    }
    public function dump(){
        
        
        return $this->expr->dump() ;
    }
}
class RelativeCondition{
    /**
     * 関係式
     * 
     * a=b,a=*,a<=d etc...
     * @var unknown_type
     */
    var $expr; 
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        $this->expr = $element->expr;
        $iterator->next();
        return $this;
    }
    public function dump(){
        return "(" . $this->expr . ")" ;
        
    }
}

$elements = array();
$elements[] = new ExpressionElement( "a=b" );

$elements[] = new OperatorElement(OperatorElement::OP_OR);
$elements[] = new ExpressionElement( "c=d" );

$elements[] = new OperatorElement(OperatorElement::OP_AND);
$elements[] = new ExpressionElement( "e=f" );

$elements[] = new OperatorElement(OperatorElement::OP_OR);
$elements[] = new ExpressionElement( "g=h" );
// (|(a=b)(&(c=d)(e=f))(g=h))
$arr= new ArrayObject($elements);
$iterator = $arr->getIterator();


$filter = new Expression();
$result = $filter->parse($iterator);

echo $result->dump();

?>