<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table auth_users_roles Field定義
*/
class CFW_Sample_Models_Base_AuthUsersRolesTableRow extends CFW_Models_Entity
{
    /** 
    * @var Number id [id]
    */
    public $id;
    /** 
    * @var String loginId [login_id]
    */
    public $loginId;
    /** 
    * @var Number aclRolesId [acl_roles_id]
    */
    public $aclRolesId;
    /** 
    * @var String description [description]
    */
    public $description;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->id = 0;
        $this->loginId = "";
        $this->aclRolesId = null;
        $this->description = "";
        
    }
    
    /**
    * 列名を指定して値を設宁E
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "id") $this->id = CFW_Util_Number::numberValue( $value );
        if($name ==  "login_id") $this->loginId = CFW_Util_String::stringValue( $value );
        if($name ==  "acl_roles_id") $this->aclRolesId = CFW_Util_Number::numberValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取征E
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取征E
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "id") return $this->id;
        if($name ==  "login_id") return $this->loginId;
        if($name ==  "acl_roles_id") return $this->aclRolesId;
        if($name ==  "description") return $this->description;
        
        return null;
    }
    
    /**
    * 持EデータからのコピE
    * @param AuthUsersRolesTableRow コピE允E
    * @return none
    */
    public function copyFrom($source)
    {
        $this->id = $source->id;
        $this->loginId = $source->loginId;
        $this->aclRolesId = $source->aclRolesId;
        $this->description = $source->description;
        
    }
}
