<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table auth_users_rolesに対応するフィールドEロパティ
*/
class CFW_Sample_Models_Base_AuthUsersRolesTableProperty extends  CFW_Models_EntityProperty
{
	/* var CFW_FieldProperties_Abstract [id] */
	public $id;
	/* var CFW_FieldProperties_Abstract [login_id] */
	public $loginId;
	/* var CFW_FieldProperties_Abstract [acl_roles_id] */
	public $aclRolesId;
	/* var CFW_FieldProperties_Abstract [description] */
	public $description;
	

    /**
    * default construct
    */
    public function __construct()
    {
    	$this->tableName = "auth_users_roles";
		$this->id =  CFW_FieldProperties_Abstract::newInstance("int", "auth_users_roles", "id","[id]", 4, 10, 0, false, 0,true);
		$this->loginId =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users_roles", "login_id","[login_id]", 64, 0, 0, false, "",false);
		$this->aclRolesId =  CFW_FieldProperties_Abstract::newInstance("int", "auth_users_roles", "acl_roles_id","[acl_roles_id]", 4, 10, 0, true, null,false);
		$this->description =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users_roles", "description","[description]", 500, 0, 0, true, "",false);
		

		$this->entityClass = "CFW_Sample_Models_Base_AuthUsersRolesTableRow";
 		
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
    	$fields = array();
		$fields[] = $this->id;
		$fields[] = $this->loginId;
		$fields[] = $this->aclRolesId;
		$fields[] = $this->description;
		
		return $fields;
    }
    /**
    * 全ての主キーをE持E
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
    	$fields = array();
        $fields[] = $this->id;
        
		return $fields;
    }
    public function getUpdateFields(){
    	$fields = array();
		if($this->id->doUpdate && !$this->id->isIdentity)$fields[] = $this->id;
		if($this->loginId->doUpdate && !$this->loginId->isIdentity)$fields[] = $this->loginId;
		if($this->aclRolesId->doUpdate && !$this->aclRolesId->isIdentity)$fields[] = $this->aclRolesId;
		if($this->description->doUpdate && !$this->description->isIdentity)$fields[] = $this->description;
		
		return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->tableName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->talbeName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
		$this->id->doUpdate = $doUpdate;
		$this->loginId->doUpdate = $doUpdate;
		$this->aclRolesId->doUpdate = $doUpdate;
		$this->description->doUpdate = $doUpdate;
		
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

    
}
