<?php
require_once "../../startup.php";
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Data_Command");
Zend_Loader::loadClass("CFW_Data_DataSource");
Zend_Loader::loadClass("CFW_Data_Parameter");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Models_Entity");
Zend_Loader::loadClass("CFW_Data_Criteria_ColumnValueCondition");
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Util_StopWatch");
Zend_Loader::loadClass("CFW_Error_Handler");
Zend_Loader::loadClass("CFW_Error_HandlerFactory");
Zend_Loader::loadFile("cfw.php");

$sw = new CFW_Util_StopWatch();
$sw->start();

$message = "";
$result = insertSample();
//$result = insert1();

function insert1(){
	try{
		return insertSample();
	}
	catch(Exception $ex){
		$factory = new CFW_Error_HandlerFactory($ex);
		$handler = $factory->createHandler();
		$handler->handle();
		
	}
}

function insertSample(){
	$connection = CFW_Data_ConnectionFactory::getConnection("default");
	$config = CFW_Config_Configuration::getInstance("connection")->connection;
	$result = 0;
	try{
		$connection->connect();
		$connection->beginTransaction();
		$property = $connection->describe("users");
		
		$dataSource = new CFW_Data_DataSource($config,$property);
		$dataSource->setConnection($connection);
		
		$entity = new CFW_Models_Entity();
		$entity->userId = "X0001";
		$entity->password = "password";
		$entity->userName= "user X0001";
		$result = $dataSource->insert($entity);
		
		
		$connection->commitTransaction();
		$connection->disconnect();
		$message = "insert complete";
	}
	catch(Exception $ex){
		$connection->rollbackTransaction();
		$connection->disconnect();
		
		$factory = new CFW_Error_HandlerFactory($ex);
		$handler = $factory->createHandler();
		$handler->handle();
		$message = "insert exception";
		
		throw $ex;
	}
	return $result;
}
$sw->stop();
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<div class="searchResult">
<?php var_dump($result);?>
</div>
<div class="searchResult">
<?php eh($message);?>
</div>
<div>ellapsed<?php echo $sw->ellapsed();?></div>

</body>
</html>