<?php
Zend_Loader::loadClass("CFW_Models_ITreeNode");
Zend_Loader::loadClass("CFW_Acl_IResource");

/**
 * @author okada
 * @package CFW_Acl
 */
class CFW_Acl_Role implements CFW_Acl_IRole{
    var $treeNode;
    public function __construct($name){
        $this->treeNode = new CFW_Models_TreeNode($name);

    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getName()
     */
    public function getName(){
        return $this->treeNode->getName();
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#setName($name)
     */
    public function setName($name){
        return $this->treeNode->setParent($name);
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getParent()
     */
    public function getParent(){
        return $this->treeNode->getParent();
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#setParent($parent)
     */
    public function setParent($parent){
        return $this->treeNode->setParent($parent);
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getChildren()
     */
    public function getChildren(){
        return $this->treeNode->getChildren();
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#getChild($name)
     */
    public function getChild($name){
        return $this->treeNode->getChild($name);
    }
    /**
     * (non-PHPdoc)
     * @see library/CFW/Models/CFW_Models_ITreeNode#setChildren($children)
     */
    public function setChildren($children){
        return $this->treeNode->setChildren($children);
    }
    /**
     * 子要素を追加する
     * @param CFW_Models_ITreeNode $node
     * @return unknown_type
     */
    public function appendChild(CFW_Models_ITreeNode $node){$this->treeNode->appendChild($node);}
    /**
     * 子要素を削除する
     * @param CFW_Models_ITreeNode $node
     * @return unknown_type
     */
    public function removeChilde(CFW_Models_ITreeNode $node){ $this->treeNode->removeChild($node); }
    /**
     * このオブジェクトが指定ノードの先祖かどうか
     * @param CFW_Models_ITreeNode $node
     * @return unknown_type
     */
    function isAncestorOf(CFW_Models_ITreeNode $node){ return $this->treeNode->isAncestorOf($node); }
    /**
     * このオブジェクトが指定ノードの子孫かどうか
     * @param CFW_Models_ITreeNode $node
     * @return unknown_type
     */
    function isDescendantOf(CFW_Models_ITreeNode $node){ return $this->treeNode->isDescendantOf($node); }
    /**
     * パスを文字列として表現する
     * @return String
     */
    public function pathString(){ return $this->treeNode->pathString(); }
    /**
     * パスを配列で返す
     * @return CFW_Models_ITreeNode
     */
    public function path(){ return $this->treeNode->path(); }
    /**
     * 指定パスのノードを見つける
     * @param array $path
     * @return CFW_Models_ITreeNode
     */
    function find($path = array()){ return $this->treeNode->find($path); }
}