<?php
Zend_Loader::loadClass("CFW_Data_Criteria_StringCondition");

/**
 * データ選択機能(EXPERIMENTAL)
 * 
 * <p>まだ実験中です。</p>
 * @author okada
 *
 */
class CFW_Data_SelectCommandBuilder{
    var $tables;
    var $criteria;
    var $fields;
    /**
     * DISTINCT,TOP 100など
     * @var unknown_type
     */
    var $option; 
    
    var $parameters;
    var $selectClause;
    var $fromClause;
    var $whereClause;
    var $orderByClause;
    var $havingClause;
    var $groupByClause;
    
    var $queryExpression;
    
    var $command;
        
    public function __construct($table,$alias){
        $this->tables = array();
        
        $this->tables[] = array("table" => $table,"alias" => $alias,"criteria" => null);
        $this->fields = array();
        $this->criteria = new CFW_Data_Criteria();
        $this->option = "";
        $this->parameters = array();
        $this->selectClause = "";
        $this->fromClause = "";
        $this->whereClause = "";
        $this->orderByClause = "";
        $this->havingClause = "";
        $this->groupByClause = "";
        $this->command = null;
    }
    public function setConnection($connection){
        $this->connection = $connection;
    }
    public function addJoin($table,$alias,$criteria){
        $this->tables[] = "INNER JOIN";
        $this->tables[] = array("table" => $table,"alias" => $alias,"criteria" => $criteria);
    }
    public function addJoinLeft($table,$alias,$criteria){
        $this->tables[] = "LEFT JOIN";
        
        $this->tables[] = array("table" => v,"alias" => $alias,"criteria" => $criteria);
    }
    public function addJoinRight($table,$alias,$criteria){
        $this->tables[] = "RIGHT JOIN";
        
        $this->tables[] = array("table" => $table,"alias" => $alias,"criteria" => $criteria);
    }
    public function addField($field,$alias){
        $this->fields[] = array("field" => $field,"alias" => $alias);
    }
    public function addFields($fields){
        $this->fields =  array_merge($this->fields,$fields);
    }
    public function setCriteria($criteria){
        $this->criteria = $criteria;
    }
    public function setOption($option){
         $this->option = $option;   
    }
    public function buildQuery(){
        $this->criteria->assemble();
        
        $this->buildSelectClause();            
        $this->buildFromClause();            
        $this->buildWhereClause();            
        $this->buildGroupByClause();            
        $this->buildHavingClause();            
        $this->buildOrderByClause();        

        $query = "SELECT";
        if($this->option != ""){
            $query .= " " . $this->option;
        }
        if($this->selectClause != ""){
            $query .= " " . $this->selectClause;
        } 
        if($this->fromClause != ""){
            $query .= " FROM " . $this->fromClause;
        } 
        if($this->whereClause != ""){
            $query .= " WHERE " . $this->whereClause;
            
        } 
        if($this->groupByClause != ""){
            $query .= " GROUP BY " . $this->groupByClause ;
        } 
        if($this->havingClause != ""){
            $query .= " HAVING " . $this->havingClause;
        } 
        if($this->orderByClause != ""){
            $query .= " ORDER BY " . $this->orderByClause ;
        } 
            $this->parameters = array_merge($this->parameters,$this->criteria->getParameters());       
        $this->queryExpression = $query;
        
    }
    private function buildSelectClause(){
        $clause = "";
        if(count($this->fields) == 0){
            $clause = "*";
        }
        else{
            foreach($this->fields as $field){
                if($clause != "") $clause .= ",";
                $clause .= $field["field"] ." AS " . $field["alias"];
            }
        }
        $this->selectClause .= $clause;
    }
    private function buildFromClause(){
        $clause = "";
        foreach($this->tables as $table){
            if(is_string($table)){
                $clause .= " {$table} "; //JOINが入るはず
                continue;
            }
            $clause .= $table["table"];
            if($table["alias"] != ""){
                $clause .= " AS " . $table["alias"];
            }
            if($table["criteria"] != null){
                $c =  $table["criteria"];
                $c->assemble();
                $clause .= " ON " . $c->getWhereExpression();
                $this->parameters = array_merge($this->parameters,$c->getParameters());       
            }
        }
        $this->fromClause = $clause;
    }
    private function buildWhereClause(){
        $this->whereClause = $this->criteria->getWhereExpression();
        
    }
    private function buildGroupByClause(){
        $this->groupByClause = $this->criteria->getGroupByExpression();
    }
    private function buildHavingClause(){
        $this->havingClause = $this->criteria->getHavingExpression();
    }
    private function buildOrderByClause(){
        $this->orderByClause = $this->criteria->getOrderByExpression();
        
    }
    public function buildCommand(){
        $this->buildQuery();
        $this->command = new CFW_Data_Command($this->queryExpression,$this->parameters);
    }
    public function getCommand(){
        return $this->command;
    }    
}