<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table MAST_MATERIALに対応するフィールドプロパティ
*/
class CFW_Sample_Models_Base_MastMaterialTableProperty extends  CFW_Models_EntityProperty
{
    /* var CFW_FieldProperties_Abstract [SITE_CODE] */
    public $siteCode;
    /* var CFW_FieldProperties_Abstract [MENU_CODE] */
    public $menuCode;
    /* var CFW_FieldProperties_Abstract [MANUSCRIPT_SEQ] */
    public $manuscriptSeq;
    /* var CFW_FieldProperties_Abstract [SEQ] */
    public $seq;
    /* var CFW_FieldProperties_Abstract [MATERIAL_CODE] */
    public $materialCode;
    /* var CFW_FieldProperties_Abstract [MATERIAL_ALIAS_NAME] */
    public $materialAliasName;
    /* var CFW_FieldProperties_Abstract [MATERIAL_INPUT_KIND_DIV] */
    public $materialInputKindDiv;
    /* var CFW_FieldProperties_Abstract [MATERIAL_INPUT_KIND_SEQ] */
    public $materialInputKindSeq;
    /* var CFW_FieldProperties_Abstract [FILE_VERSION] */
    public $fileVersion;
    /* var CFW_FieldProperties_Abstract [FILE_EXTENTION] */
    public $fileExtention;
    /* var CFW_FieldProperties_Abstract [WHOLE_PIXCEL_X] */
    public $wholePixcelX;
    /* var CFW_FieldProperties_Abstract [WHOLE_PIXCEL_Y] */
    public $wholePixcelY;
    /* var CFW_FieldProperties_Abstract [WHOLE_PIXCEL_LIMIT] */
    public $wholePixcelLimit;
    /* var CFW_FieldProperties_Abstract [WHOLE_PIXCEL_LIMIT_DIV] */
    public $wholePixcelLimitDiv;
    /* var CFW_FieldProperties_Abstract [WHOLE_PIXCEL_LIMIT_SEQ] */
    public $wholePixcelLimitSeq;
    /* var CFW_FieldProperties_Abstract [AD_PIXCEL_X] */
    public $adPixcelX;
    /* var CFW_FieldProperties_Abstract [AD_PIXCEL_Y] */
    public $adPixcelY;
    /* var CFW_FieldProperties_Abstract [AD_PIXCEL_LIMIT] */
    public $adPixcelLimit;
    /* var CFW_FieldProperties_Abstract [AD_PIXCEL_LIMIT_DIV] */
    public $adPixcelLimitDiv;
    /* var CFW_FieldProperties_Abstract [AD_PIXCEL_LIMIT_SEQ] */
    public $adPixcelLimitSeq;
    /* var CFW_FieldProperties_Abstract [RF_PIXCEL_X] */
    public $rfPixcelX;
    /* var CFW_FieldProperties_Abstract [RF_PIXCEL_Y] */
    public $rfPixcelY;
    /* var CFW_FieldProperties_Abstract [RF_PIXCEL_LIMIT] */
    public $rfPixcelLimit;
    /* var CFW_FieldProperties_Abstract [RF_PIXCEL_LIMIT_DIV] */
    public $rfPixcelLimitDiv;
    /* var CFW_FieldProperties_Abstract [RF_PIXCEL_LIMIT_SEQ] */
    public $rfPixcelLimitSeq;
    /* var CFW_FieldProperties_Abstract [COLOR_CAPACITY] */
    public $colorCapacity;
    /* var CFW_FieldProperties_Abstract [COLOR_CAPACITY_LIMIT] */
    public $colorCapacityLimit;
    /* var CFW_FieldProperties_Abstract [COLOR_CAPACITY_LIMIT_DIV] */
    public $colorCapacityLimitDiv;
    /* var CFW_FieldProperties_Abstract [COLOR_CAPACITY_LIMIT_SEQ] */
    public $colorCapacityLimitSeq;
    /* var CFW_FieldProperties_Abstract [MONO_CAPACITY] */
    public $monoCapacity;
    /* var CFW_FieldProperties_Abstract [MONO_CAPACITY_LIMIT] */
    public $monoCapacityLimit;
    /* var CFW_FieldProperties_Abstract [MONO_CAPACITY_LIMIT_DIV] */
    public $monoCapacityLimitDiv;
    /* var CFW_FieldProperties_Abstract [MONO_CAPACITY_LIMIT_SEQ] */
    public $monoCapacityLimitSeq;
    /* var CFW_FieldProperties_Abstract [MAIN_LETTER_FLAG] */
    public $mainLetterFlag;
    /* var CFW_FieldProperties_Abstract [MAIN_LETTER] */
    public $mainLetter;
    /* var CFW_FieldProperties_Abstract [M_LETTER_LIMIT] */
    public $mLetterLimit;
    /* var CFW_FieldProperties_Abstract [M_LETTER_LIMIT_DIV] */
    public $mLetterLimitDiv;
    /* var CFW_FieldProperties_Abstract [M_LETTER_LIMIT_SEQ] */
    public $mLetterLimitSeq;
    /* var CFW_FieldProperties_Abstract [MAIN_LINE] */
    public $mainLine;
    /* var CFW_FieldProperties_Abstract [M_LINE_LIMIT] */
    public $mLineLimit;
    /* var CFW_FieldProperties_Abstract [M_LINE_LIMIT_DIV] */
    public $mLineLimitDiv;
    /* var CFW_FieldProperties_Abstract [M_LINE_LIMIT_SEQ] */
    public $mLineLimitSeq;
    /* var CFW_FieldProperties_Abstract [M_2BYTECHAR_FLAG] */
    public $m2bytecharFlag;
    /* var CFW_FieldProperties_Abstract [M_1BYTECHAR_FLAG] */
    public $m1bytecharFlag;
    /* var CFW_FieldProperties_Abstract [M_KANA_FLAG] */
    public $mKanaFlag;
    /* var CFW_FieldProperties_Abstract [M_RF_FLAG] */
    public $mRfFlag;
    /* var CFW_FieldProperties_Abstract [M_RF_REMARKS] */
    public $mRfRemarks;
    /* var CFW_FieldProperties_Abstract [M_PICTURE_CHAR_FLAG] */
    public $mPictureCharFlag;
    /* var CFW_FieldProperties_Abstract [M_PICTURE_CHAR_EXTEND_FLAG] */
    public $mPictureCharExtendFlag;
    /* var CFW_FieldProperties_Abstract [TITLE_LETTER_FLAG] */
    public $titleLetterFlag;
    /* var CFW_FieldProperties_Abstract [TITEL_LETTER] */
    public $titelLetter;
    /* var CFW_FieldProperties_Abstract [T_LETTER_LIMIT] */
    public $tLetterLimit;
    /* var CFW_FieldProperties_Abstract [T_LETTER_LIMIT_DIV] */
    public $tLetterLimitDiv;
    /* var CFW_FieldProperties_Abstract [T_LETTER_LIMIT_SEQ] */
    public $tLetterLimitSeq;
    /* var CFW_FieldProperties_Abstract [T_LINE] */
    public $tLine;
    /* var CFW_FieldProperties_Abstract [T_LINE_LIMIT] */
    public $tLineLimit;
    /* var CFW_FieldProperties_Abstract [T_LINE_LIMIT_DIV] */
    public $tLineLimitDiv;
    /* var CFW_FieldProperties_Abstract [T_LINE_LIMIT_SEQ] */
    public $tLineLimitSeq;
    /* var CFW_FieldProperties_Abstract [T_2BYTECHAR_FLAG] */
    public $t2bytecharFlag;
    /* var CFW_FieldProperties_Abstract [T_1BYTECHAR_FLAG] */
    public $t1bytecharFlag;
    /* var CFW_FieldProperties_Abstract [T_KANA_FLAG] */
    public $tKanaFlag;
    /* var CFW_FieldProperties_Abstract [T_RF_FLAG] */
    public $tRfFlag;
    /* var CFW_FieldProperties_Abstract [T_RF_REMARKS] */
    public $tRfRemarks;
    /* var CFW_FieldProperties_Abstract [T_PICTURE_CHAR_FLAG] */
    public $tPictureCharFlag;
    /* var CFW_FieldProperties_Abstract [T_PICTURE_CHAR_EXTEND_FLAG] */
    public $tPictureCharExtendFlag;
    /* var CFW_FieldProperties_Abstract [URL_FLAG] */
    public $urlFlag;
    /* var CFW_FieldProperties_Abstract [URL_LETTER] */
    public $urlLetter;
    /* var CFW_FieldProperties_Abstract [U_LETTER_LIMIT] */
    public $uLetterLimit;
    /* var CFW_FieldProperties_Abstract [U_LETTER_LIMIT_DIV] */
    public $uLetterLimitDiv;
    /* var CFW_FieldProperties_Abstract [U_LETTER_LIMIT_SEQ] */
    public $uLetterLimitSeq;
    /* var CFW_FieldProperties_Abstract [ALT_FLAG] */
    public $altFlag;
    /* var CFW_FieldProperties_Abstract [ALT_LETTER] */
    public $altLetter;
    /* var CFW_FieldProperties_Abstract [A_LETTER_LIMIT] */
    public $aLetterLimit;
    /* var CFW_FieldProperties_Abstract [A_LETTER_LIMIT_DIV] */
    public $aLetterLimitDiv;
    /* var CFW_FieldProperties_Abstract [A_LETTER_LIMIT_SEQ] */
    public $aLetterLimitSeq;
    /* var CFW_FieldProperties_Abstract [A_2BYTECHAR_FLAG] */
    public $a2bytecharFlag;
    /* var CFW_FieldProperties_Abstract [A_1BYTECHAR_FLAG] */
    public $a1bytecharFlag;
    /* var CFW_FieldProperties_Abstract [A_KANA_FLAG] */
    public $aKanaFlag;
    /* var CFW_FieldProperties_Abstract [LOOP_LIMIT_FLAG] */
    public $loopLimitFlag;
    /* var CFW_FieldProperties_Abstract [L_COUNT] */
    public $lCount;
    /* var CFW_FieldProperties_Abstract [L_COUNT_OPEN_FLAG] */
    public $lCountOpenFlag;
    /* var CFW_FieldProperties_Abstract [L_ROUND_LIMIT_FLAG] */
    public $lRoundLimitFlag;
    /* var CFW_FieldProperties_Abstract [L_ROUND_SECOND] */
    public $lRoundSecond;
    /* var CFW_FieldProperties_Abstract [L_ROUND_LIMIT] */
    public $lRoundLimit;
    /* var CFW_FieldProperties_Abstract [L_ROUND_LIMIT_DIV] */
    public $lRoundLimitDiv;
    /* var CFW_FieldProperties_Abstract [L_ROUND_LIMIT_SEQ] */
    public $lRoundLimitSeq;
    /* var CFW_FieldProperties_Abstract [ANIMATION_FLAG] */
    public $animationFlag;
    /* var CFW_FieldProperties_Abstract [ANIMATION_COUNT] */
    public $animationCount;
    /* var CFW_FieldProperties_Abstract [COLOR_FLAG] */
    public $colorFlag;
    /* var CFW_FieldProperties_Abstract [WITH_MONO_FLAG] */
    public $withMonoFlag;
    /* var CFW_FieldProperties_Abstract [DHTML_FLAG] */
    public $dhtmlFlag;
    /* var CFW_FieldProperties_Abstract [LINK_TARGET] */
    public $linkTarget;
    /* var CFW_FieldProperties_Abstract [PC_CHAR_FLAG] */
    public $pcCharFlag;
    /* var CFW_FieldProperties_Abstract [SOUND_FLAG] */
    public $soundFlag;
    /* var CFW_FieldProperties_Abstract [SOUND_DEFAULT_FLAG] */
    public $soundDefaultFlag;
    /* var CFW_FieldProperties_Abstract [MUTEBUTTON_FLAG] */
    public $mutebuttonFlag;
    /* var CFW_FieldProperties_Abstract [CLOSEBUTTON_FLAG] */
    public $closebuttonFlag;
    /* var CFW_FieldProperties_Abstract [ENCODE] */
    public $encode;
    /* var CFW_FieldProperties_Abstract [ENCODE_DIV] */
    public $encodeDiv;
    /* var CFW_FieldProperties_Abstract [ENCODE_SEQ] */
    public $encodeSeq;
    /* var CFW_FieldProperties_Abstract [BIT_RATE_MIN] */
    public $bitRateMin;
    /* var CFW_FieldProperties_Abstract [BIT_RATE_MAX] */
    public $bitRateMax;
    /* var CFW_FieldProperties_Abstract [SOUND_ENCODE] */
    public $soundEncode;
    /* var CFW_FieldProperties_Abstract [SOUND_ENCODE_DIV] */
    public $soundEncodeDiv;
    /* var CFW_FieldProperties_Abstract [SOUND_ENCODE_SEQ] */
    public $soundEncodeSeq;
    /* var CFW_FieldProperties_Abstract [SOUND_BIT_RATE_MIN] */
    public $soundBitRateMin;
    /* var CFW_FieldProperties_Abstract [SOUND_BIT_RATE_MAX] */
    public $soundBitRateMax;
    /* var CFW_FieldProperties_Abstract [SOUND_ENCODE_VERSION] */
    public $soundEncodeVersion;
    /* var CFW_FieldProperties_Abstract [START_AREA_REMARKS] */
    public $startAreaRemarks;
    /* var CFW_FieldProperties_Abstract [FLA_FILE_VERSION] */
    public $flaFileVersion;
    /* var CFW_FieldProperties_Abstract [FLA_FILE_MUST_FLAG] */
    public $flaFileMustFlag;
    /* var CFW_FieldProperties_Abstract [FLA_FILE_PUBLISH_FLAG] */
    public $flaFilePublishFlag;
    /* var CFW_FieldProperties_Abstract [MUST_FLAG] */
    public $mustFlag;
    /* var CFW_FieldProperties_Abstract [REMARKS] */
    public $remarks;
    /* var CFW_FieldProperties_Abstract [REG_PTN_NO] */
    public $regPtnNo;
    /* var CFW_FieldProperties_Abstract [USE_MENU_CARRIER_FLAG] */
    public $useMenuCarrierFlag;
    /* var CFW_FieldProperties_Abstract [ADMISSION_AD_CODE] */
    public $admissionAdCode;
    /* var CFW_FieldProperties_Abstract [MATERIAL_PATTERN_SEQ] */
    public $materialPatternSeq;
    /* var CFW_FieldProperties_Abstract [SPECIAL_FLAG] */
    public $specialFlag;
    /* var CFW_FieldProperties_Abstract [VALID_FLAG] */
    public $validFlag;
    /* var CFW_FieldProperties_Abstract [INSERT_DATE_TIME] */
    public $insertDateTime;
    /* var CFW_FieldProperties_Abstract [INSERT_OPERATOR_CODE] */
    public $insertOperatorCode;
    /* var CFW_FieldProperties_Abstract [UPDATE_DATE_TIME] */
    public $updateDateTime;
    /* var CFW_FieldProperties_Abstract [OPERATOR_CODE] */
    public $operatorCode;
    

    /**
    * default construct
    */
    public function __construct()
    {
        $this->entityName = "MAST_MATERIAL";
        $this->siteCode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "SITE_CODE","[SITE_CODE]", 5, 0, 0, false, "",false);
        $this->menuCode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "MENU_CODE","[MENU_CODE]", 4, 0, 0, false, "",false);
        $this->manuscriptSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MANUSCRIPT_SEQ","[MANUSCRIPT_SEQ]", 2, 5, 0, false, 0,false);
        $this->seq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SEQ","[SEQ]", 2, 5, 0, false, 0,false);
        $this->materialCode =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MATERIAL_CODE","[MATERIAL_CODE]", 2, 5, 0, true, null,false);
        $this->materialAliasName =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "MATERIAL_ALIAS_NAME","[MATERIAL_ALIAS_NAME]", 50, 0, 0, true, "",false);
        $this->materialInputKindDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MATERIAL_INPUT_KIND_DIV","[MATERIAL_INPUT_KIND_DIV]", 2, 5, 0, true, null,false);
        $this->materialInputKindSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MATERIAL_INPUT_KIND_SEQ","[MATERIAL_INPUT_KIND_SEQ]", 2, 5, 0, true, null,false);
        $this->fileVersion =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "FILE_VERSION","[FILE_VERSION]", 50, 0, 0, true, "",false);
        $this->fileExtention =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "FILE_EXTENTION","[FILE_EXTENTION]", 50, 0, 0, true, "",false);
        $this->wholePixcelX =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "WHOLE_PIXCEL_X","[WHOLE_PIXCEL_X]", 2, 5, 0, true, null,false);
        $this->wholePixcelY =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "WHOLE_PIXCEL_Y","[WHOLE_PIXCEL_Y]", 2, 5, 0, true, null,false);
        $this->wholePixcelLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "WHOLE_PIXCEL_LIMIT","[WHOLE_PIXCEL_LIMIT]", 50, 0, 0, true, "",false);
        $this->wholePixcelLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "WHOLE_PIXCEL_LIMIT_DIV","[WHOLE_PIXCEL_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->wholePixcelLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "WHOLE_PIXCEL_LIMIT_SEQ","[WHOLE_PIXCEL_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->adPixcelX =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "AD_PIXCEL_X","[AD_PIXCEL_X]", 2, 5, 0, true, null,false);
        $this->adPixcelY =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "AD_PIXCEL_Y","[AD_PIXCEL_Y]", 2, 5, 0, true, null,false);
        $this->adPixcelLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "AD_PIXCEL_LIMIT","[AD_PIXCEL_LIMIT]", 50, 0, 0, true, "",false);
        $this->adPixcelLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "AD_PIXCEL_LIMIT_DIV","[AD_PIXCEL_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->adPixcelLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "AD_PIXCEL_LIMIT_SEQ","[AD_PIXCEL_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->rfPixcelX =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "RF_PIXCEL_X","[RF_PIXCEL_X]", 2, 5, 0, true, null,false);
        $this->rfPixcelY =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "RF_PIXCEL_Y","[RF_PIXCEL_Y]", 2, 5, 0, true, null,false);
        $this->rfPixcelLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "RF_PIXCEL_LIMIT","[RF_PIXCEL_LIMIT]", 50, 0, 0, true, "",false);
        $this->rfPixcelLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "RF_PIXCEL_LIMIT_DIV","[RF_PIXCEL_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->rfPixcelLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "RF_PIXCEL_LIMIT_SEQ","[RF_PIXCEL_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->colorCapacity =  CFW_FieldProperties_Abstract::newInstance("decimal", "MAST_MATERIAL", "COLOR_CAPACITY","[COLOR_CAPACITY]", 8, 6, 2, true, null,false);
        $this->colorCapacityLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "COLOR_CAPACITY_LIMIT","[COLOR_CAPACITY_LIMIT]", 50, 0, 0, true, "",false);
        $this->colorCapacityLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "COLOR_CAPACITY_LIMIT_DIV","[COLOR_CAPACITY_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->colorCapacityLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "COLOR_CAPACITY_LIMIT_SEQ","[COLOR_CAPACITY_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->monoCapacity =  CFW_FieldProperties_Abstract::newInstance("decimal", "MAST_MATERIAL", "MONO_CAPACITY","[MONO_CAPACITY]", 8, 6, 2, true, null,false);
        $this->monoCapacityLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "MONO_CAPACITY_LIMIT","[MONO_CAPACITY_LIMIT]", 50, 0, 0, true, "",false);
        $this->monoCapacityLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MONO_CAPACITY_LIMIT_DIV","[MONO_CAPACITY_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->monoCapacityLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MONO_CAPACITY_LIMIT_SEQ","[MONO_CAPACITY_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->mainLetterFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MAIN_LETTER_FLAG","[MAIN_LETTER_FLAG]", 2, 5, 0, true, null,false);
        $this->mainLetter =  CFW_FieldProperties_Abstract::newInstance("decimal", "MAST_MATERIAL", "MAIN_LETTER","[MAIN_LETTER]", 8, 6, 1, true, null,false);
        $this->mLetterLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "M_LETTER_LIMIT","[M_LETTER_LIMIT]", 50, 0, 0, true, "",false);
        $this->mLetterLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_LETTER_LIMIT_DIV","[M_LETTER_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->mLetterLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_LETTER_LIMIT_SEQ","[M_LETTER_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->mainLine =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MAIN_LINE","[MAIN_LINE]", 2, 5, 0, true, null,false);
        $this->mLineLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "M_LINE_LIMIT","[M_LINE_LIMIT]", 50, 0, 0, true, "",false);
        $this->mLineLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_LINE_LIMIT_DIV","[M_LINE_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->mLineLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_LINE_LIMIT_SEQ","[M_LINE_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->m2bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_2BYTECHAR_FLAG","[M_2BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->m1bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_1BYTECHAR_FLAG","[M_1BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->mKanaFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_KANA_FLAG","[M_KANA_FLAG]", 2, 5, 0, true, null,false);
        $this->mRfFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_RF_FLAG","[M_RF_FLAG]", 2, 5, 0, true, null,false);
        $this->mRfRemarks =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "M_RF_REMARKS","[M_RF_REMARKS]", 100, 0, 0, true, "",false);
        $this->mPictureCharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_PICTURE_CHAR_FLAG","[M_PICTURE_CHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->mPictureCharExtendFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "M_PICTURE_CHAR_EXTEND_FLAG","[M_PICTURE_CHAR_EXTEND_FLAG]", 2, 5, 0, true, null,false);
        $this->titleLetterFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "TITLE_LETTER_FLAG","[TITLE_LETTER_FLAG]", 2, 5, 0, true, null,false);
        $this->titelLetter =  CFW_FieldProperties_Abstract::newInstance("decimal", "MAST_MATERIAL", "TITEL_LETTER","[TITEL_LETTER]", 8, 6, 1, true, null,false);
        $this->tLetterLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "T_LETTER_LIMIT","[T_LETTER_LIMIT]", 50, 0, 0, true, "",false);
        $this->tLetterLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_LETTER_LIMIT_DIV","[T_LETTER_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->tLetterLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_LETTER_LIMIT_SEQ","[T_LETTER_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->tLine =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_LINE","[T_LINE]", 2, 5, 0, true, null,false);
        $this->tLineLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "T_LINE_LIMIT","[T_LINE_LIMIT]", 50, 0, 0, true, "",false);
        $this->tLineLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_LINE_LIMIT_DIV","[T_LINE_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->tLineLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_LINE_LIMIT_SEQ","[T_LINE_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->t2bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_2BYTECHAR_FLAG","[T_2BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->t1bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_1BYTECHAR_FLAG","[T_1BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->tKanaFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_KANA_FLAG","[T_KANA_FLAG]", 2, 5, 0, true, null,false);
        $this->tRfFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_RF_FLAG","[T_RF_FLAG]", 2, 5, 0, true, null,false);
        $this->tRfRemarks =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "T_RF_REMARKS","[T_RF_REMARKS]", 100, 0, 0, true, "",false);
        $this->tPictureCharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_PICTURE_CHAR_FLAG","[T_PICTURE_CHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->tPictureCharExtendFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "T_PICTURE_CHAR_EXTEND_FLAG","[T_PICTURE_CHAR_EXTEND_FLAG]", 2, 5, 0, true, null,false);
        $this->urlFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "URL_FLAG","[URL_FLAG]", 2, 5, 0, true, null,false);
        $this->urlLetter =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "URL_LETTER","[URL_LETTER]", 2, 5, 0, true, null,false);
        $this->uLetterLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "U_LETTER_LIMIT","[U_LETTER_LIMIT]", 50, 0, 0, true, "",false);
        $this->uLetterLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "U_LETTER_LIMIT_DIV","[U_LETTER_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->uLetterLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "U_LETTER_LIMIT_SEQ","[U_LETTER_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->altFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ALT_FLAG","[ALT_FLAG]", 2, 5, 0, true, null,false);
        $this->altLetter =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ALT_LETTER","[ALT_LETTER]", 2, 5, 0, true, null,false);
        $this->aLetterLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "A_LETTER_LIMIT","[A_LETTER_LIMIT]", 50, 0, 0, true, "",false);
        $this->aLetterLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "A_LETTER_LIMIT_DIV","[A_LETTER_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->aLetterLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "A_LETTER_LIMIT_SEQ","[A_LETTER_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->a2bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "A_2BYTECHAR_FLAG","[A_2BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->a1bytecharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "A_1BYTECHAR_FLAG","[A_1BYTECHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->aKanaFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "A_KANA_FLAG","[A_KANA_FLAG]", 2, 5, 0, true, null,false);
        $this->loopLimitFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "LOOP_LIMIT_FLAG","[LOOP_LIMIT_FLAG]", 2, 5, 0, true, null,false);
        $this->lCount =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "L_COUNT","[L_COUNT]", 2, 5, 0, true, null,false);
        $this->lCountOpenFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "L_COUNT_OPEN_FLAG","[L_COUNT_OPEN_FLAG]", 2, 5, 0, true, null,false);
        $this->lRoundLimitFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "L_ROUND_LIMIT_FLAG","[L_ROUND_LIMIT_FLAG]", 2, 5, 0, true, null,false);
        $this->lRoundSecond =  CFW_FieldProperties_Abstract::newInstance("decimal", "MAST_MATERIAL", "L_ROUND_SECOND","[L_ROUND_SECOND]", 8, 6, 1, true, null,false);
        $this->lRoundLimit =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "L_ROUND_LIMIT","[L_ROUND_LIMIT]", 50, 0, 0, true, "",false);
        $this->lRoundLimitDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "L_ROUND_LIMIT_DIV","[L_ROUND_LIMIT_DIV]", 2, 5, 0, true, null,false);
        $this->lRoundLimitSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "L_ROUND_LIMIT_SEQ","[L_ROUND_LIMIT_SEQ]", 2, 5, 0, true, null,false);
        $this->animationFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ANIMATION_FLAG","[ANIMATION_FLAG]", 2, 5, 0, true, null,false);
        $this->animationCount =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ANIMATION_COUNT","[ANIMATION_COUNT]", 2, 5, 0, true, null,false);
        $this->colorFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "COLOR_FLAG","[COLOR_FLAG]", 2, 5, 0, true, null,false);
        $this->withMonoFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "WITH_MONO_FLAG","[WITH_MONO_FLAG]", 2, 5, 0, true, null,false);
        $this->dhtmlFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "DHTML_FLAG","[DHTML_FLAG]", 2, 5, 0, true, null,false);
        $this->linkTarget =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "LINK_TARGET","[LINK_TARGET]", 50, 0, 0, true, "",false);
        $this->pcCharFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "PC_CHAR_FLAG","[PC_CHAR_FLAG]", 2, 5, 0, true, null,false);
        $this->soundFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_FLAG","[SOUND_FLAG]", 2, 5, 0, true, null,false);
        $this->soundDefaultFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_DEFAULT_FLAG","[SOUND_DEFAULT_FLAG]", 2, 5, 0, true, null,false);
        $this->mutebuttonFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MUTEBUTTON_FLAG","[MUTEBUTTON_FLAG]", 2, 5, 0, true, null,false);
        $this->closebuttonFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "CLOSEBUTTON_FLAG","[CLOSEBUTTON_FLAG]", 2, 5, 0, true, null,false);
        $this->encode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "ENCODE","[ENCODE]", 20, 0, 0, true, "",false);
        $this->encodeDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ENCODE_DIV","[ENCODE_DIV]", 2, 5, 0, true, null,false);
        $this->encodeSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "ENCODE_SEQ","[ENCODE_SEQ]", 2, 5, 0, true, null,false);
        $this->bitRateMin =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "BIT_RATE_MIN","[BIT_RATE_MIN]", 2, 5, 0, true, null,false);
        $this->bitRateMax =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "BIT_RATE_MAX","[BIT_RATE_MAX]", 2, 5, 0, true, null,false);
        $this->soundEncode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "SOUND_ENCODE","[SOUND_ENCODE]", 20, 0, 0, true, "",false);
        $this->soundEncodeDiv =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_ENCODE_DIV","[SOUND_ENCODE_DIV]", 2, 5, 0, true, null,false);
        $this->soundEncodeSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_ENCODE_SEQ","[SOUND_ENCODE_SEQ]", 2, 5, 0, true, null,false);
        $this->soundBitRateMin =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_BIT_RATE_MIN","[SOUND_BIT_RATE_MIN]", 2, 5, 0, true, null,false);
        $this->soundBitRateMax =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SOUND_BIT_RATE_MAX","[SOUND_BIT_RATE_MAX]", 2, 5, 0, true, null,false);
        $this->soundEncodeVersion =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "SOUND_ENCODE_VERSION","[SOUND_ENCODE_VERSION]", 50, 0, 0, true, "",false);
        $this->startAreaRemarks =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "START_AREA_REMARKS","[START_AREA_REMARKS]", 200, 0, 0, true, "",false);
        $this->flaFileVersion =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "FLA_FILE_VERSION","[FLA_FILE_VERSION]", 50, 0, 0, true, "",false);
        $this->flaFileMustFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "FLA_FILE_MUST_FLAG","[FLA_FILE_MUST_FLAG]", 2, 5, 0, true, null,false);
        $this->flaFilePublishFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "FLA_FILE_PUBLISH_FLAG","[FLA_FILE_PUBLISH_FLAG]", 2, 5, 0, true, null,false);
        $this->mustFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MUST_FLAG","[MUST_FLAG]", 2, 5, 0, true, null,false);
        $this->remarks =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "REMARKS","[REMARKS]", 500, 0, 0, true, "",false);
        $this->regPtnNo =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "REG_PTN_NO","[REG_PTN_NO]", 2, 5, 0, true, null,false);
        $this->useMenuCarrierFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "USE_MENU_CARRIER_FLAG","[USE_MENU_CARRIER_FLAG]", 2, 5, 0, true, null,false);
        $this->admissionAdCode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "ADMISSION_AD_CODE","[ADMISSION_AD_CODE]", 10, 0, 0, true, "",false);
        $this->materialPatternSeq =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "MATERIAL_PATTERN_SEQ","[MATERIAL_PATTERN_SEQ]", 2, 5, 0, true, null,false);
        $this->specialFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "SPECIAL_FLAG","[SPECIAL_FLAG]", 2, 5, 0, true, null,false);
        $this->validFlag =  CFW_FieldProperties_Abstract::newInstance("smallint", "MAST_MATERIAL", "VALID_FLAG","[VALID_FLAG]", 2, 5, 0, true, null,false);
        $this->insertDateTime =  CFW_FieldProperties_Abstract::newInstance("smalldatetime", "MAST_MATERIAL", "INSERT_DATE_TIME","[INSERT_DATE_TIME]", 16, 16, 0, true, null,false);
        $this->insertOperatorCode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "INSERT_OPERATOR_CODE","[INSERT_OPERATOR_CODE]", 6, 0, 0, true, "",false);
        $this->updateDateTime =  CFW_FieldProperties_Abstract::newInstance("smalldatetime", "MAST_MATERIAL", "UPDATE_DATE_TIME","[UPDATE_DATE_TIME]", 16, 16, 0, true, null,false);
        $this->operatorCode =  CFW_FieldProperties_Abstract::newInstance("varchar", "MAST_MATERIAL", "OPERATOR_CODE","[OPERATOR_CODE]", 6, 0, 0, true, "",false);
        

        $this->entityClass = "CFW_Sample_Models_Base_MastMaterialTableRow";
         
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
        $fields = array();
        $fields[] = $this->siteCode;
        $fields[] = $this->menuCode;
        $fields[] = $this->manuscriptSeq;
        $fields[] = $this->seq;
        $fields[] = $this->materialCode;
        $fields[] = $this->materialAliasName;
        $fields[] = $this->materialInputKindDiv;
        $fields[] = $this->materialInputKindSeq;
        $fields[] = $this->fileVersion;
        $fields[] = $this->fileExtention;
        $fields[] = $this->wholePixcelX;
        $fields[] = $this->wholePixcelY;
        $fields[] = $this->wholePixcelLimit;
        $fields[] = $this->wholePixcelLimitDiv;
        $fields[] = $this->wholePixcelLimitSeq;
        $fields[] = $this->adPixcelX;
        $fields[] = $this->adPixcelY;
        $fields[] = $this->adPixcelLimit;
        $fields[] = $this->adPixcelLimitDiv;
        $fields[] = $this->adPixcelLimitSeq;
        $fields[] = $this->rfPixcelX;
        $fields[] = $this->rfPixcelY;
        $fields[] = $this->rfPixcelLimit;
        $fields[] = $this->rfPixcelLimitDiv;
        $fields[] = $this->rfPixcelLimitSeq;
        $fields[] = $this->colorCapacity;
        $fields[] = $this->colorCapacityLimit;
        $fields[] = $this->colorCapacityLimitDiv;
        $fields[] = $this->colorCapacityLimitSeq;
        $fields[] = $this->monoCapacity;
        $fields[] = $this->monoCapacityLimit;
        $fields[] = $this->monoCapacityLimitDiv;
        $fields[] = $this->monoCapacityLimitSeq;
        $fields[] = $this->mainLetterFlag;
        $fields[] = $this->mainLetter;
        $fields[] = $this->mLetterLimit;
        $fields[] = $this->mLetterLimitDiv;
        $fields[] = $this->mLetterLimitSeq;
        $fields[] = $this->mainLine;
        $fields[] = $this->mLineLimit;
        $fields[] = $this->mLineLimitDiv;
        $fields[] = $this->mLineLimitSeq;
        $fields[] = $this->m2bytecharFlag;
        $fields[] = $this->m1bytecharFlag;
        $fields[] = $this->mKanaFlag;
        $fields[] = $this->mRfFlag;
        $fields[] = $this->mRfRemarks;
        $fields[] = $this->mPictureCharFlag;
        $fields[] = $this->mPictureCharExtendFlag;
        $fields[] = $this->titleLetterFlag;
        $fields[] = $this->titelLetter;
        $fields[] = $this->tLetterLimit;
        $fields[] = $this->tLetterLimitDiv;
        $fields[] = $this->tLetterLimitSeq;
        $fields[] = $this->tLine;
        $fields[] = $this->tLineLimit;
        $fields[] = $this->tLineLimitDiv;
        $fields[] = $this->tLineLimitSeq;
        $fields[] = $this->t2bytecharFlag;
        $fields[] = $this->t1bytecharFlag;
        $fields[] = $this->tKanaFlag;
        $fields[] = $this->tRfFlag;
        $fields[] = $this->tRfRemarks;
        $fields[] = $this->tPictureCharFlag;
        $fields[] = $this->tPictureCharExtendFlag;
        $fields[] = $this->urlFlag;
        $fields[] = $this->urlLetter;
        $fields[] = $this->uLetterLimit;
        $fields[] = $this->uLetterLimitDiv;
        $fields[] = $this->uLetterLimitSeq;
        $fields[] = $this->altFlag;
        $fields[] = $this->altLetter;
        $fields[] = $this->aLetterLimit;
        $fields[] = $this->aLetterLimitDiv;
        $fields[] = $this->aLetterLimitSeq;
        $fields[] = $this->a2bytecharFlag;
        $fields[] = $this->a1bytecharFlag;
        $fields[] = $this->aKanaFlag;
        $fields[] = $this->loopLimitFlag;
        $fields[] = $this->lCount;
        $fields[] = $this->lCountOpenFlag;
        $fields[] = $this->lRoundLimitFlag;
        $fields[] = $this->lRoundSecond;
        $fields[] = $this->lRoundLimit;
        $fields[] = $this->lRoundLimitDiv;
        $fields[] = $this->lRoundLimitSeq;
        $fields[] = $this->animationFlag;
        $fields[] = $this->animationCount;
        $fields[] = $this->colorFlag;
        $fields[] = $this->withMonoFlag;
        $fields[] = $this->dhtmlFlag;
        $fields[] = $this->linkTarget;
        $fields[] = $this->pcCharFlag;
        $fields[] = $this->soundFlag;
        $fields[] = $this->soundDefaultFlag;
        $fields[] = $this->mutebuttonFlag;
        $fields[] = $this->closebuttonFlag;
        $fields[] = $this->encode;
        $fields[] = $this->encodeDiv;
        $fields[] = $this->encodeSeq;
        $fields[] = $this->bitRateMin;
        $fields[] = $this->bitRateMax;
        $fields[] = $this->soundEncode;
        $fields[] = $this->soundEncodeDiv;
        $fields[] = $this->soundEncodeSeq;
        $fields[] = $this->soundBitRateMin;
        $fields[] = $this->soundBitRateMax;
        $fields[] = $this->soundEncodeVersion;
        $fields[] = $this->startAreaRemarks;
        $fields[] = $this->flaFileVersion;
        $fields[] = $this->flaFileMustFlag;
        $fields[] = $this->flaFilePublishFlag;
        $fields[] = $this->mustFlag;
        $fields[] = $this->remarks;
        $fields[] = $this->regPtnNo;
        $fields[] = $this->useMenuCarrierFlag;
        $fields[] = $this->admissionAdCode;
        $fields[] = $this->materialPatternSeq;
        $fields[] = $this->specialFlag;
        $fields[] = $this->validFlag;
        $fields[] = $this->insertDateTime;
        $fields[] = $this->insertOperatorCode;
        $fields[] = $this->updateDateTime;
        $fields[] = $this->operatorCode;
        
        return $fields;
    }
    /**
    * 全ての主キーを列挙
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
        $fields = array();
        
        return $fields;
    }
    public function getUpdateFields(){
        $fields = array();
        if($this->siteCode->doUpdate && !$this->siteCode->isIdentity)$fields[] = $this->siteCode;
        if($this->menuCode->doUpdate && !$this->menuCode->isIdentity)$fields[] = $this->menuCode;
        if($this->manuscriptSeq->doUpdate && !$this->manuscriptSeq->isIdentity)$fields[] = $this->manuscriptSeq;
        if($this->seq->doUpdate && !$this->seq->isIdentity)$fields[] = $this->seq;
        if($this->materialCode->doUpdate && !$this->materialCode->isIdentity)$fields[] = $this->materialCode;
        if($this->materialAliasName->doUpdate && !$this->materialAliasName->isIdentity)$fields[] = $this->materialAliasName;
        if($this->materialInputKindDiv->doUpdate && !$this->materialInputKindDiv->isIdentity)$fields[] = $this->materialInputKindDiv;
        if($this->materialInputKindSeq->doUpdate && !$this->materialInputKindSeq->isIdentity)$fields[] = $this->materialInputKindSeq;
        if($this->fileVersion->doUpdate && !$this->fileVersion->isIdentity)$fields[] = $this->fileVersion;
        if($this->fileExtention->doUpdate && !$this->fileExtention->isIdentity)$fields[] = $this->fileExtention;
        if($this->wholePixcelX->doUpdate && !$this->wholePixcelX->isIdentity)$fields[] = $this->wholePixcelX;
        if($this->wholePixcelY->doUpdate && !$this->wholePixcelY->isIdentity)$fields[] = $this->wholePixcelY;
        if($this->wholePixcelLimit->doUpdate && !$this->wholePixcelLimit->isIdentity)$fields[] = $this->wholePixcelLimit;
        if($this->wholePixcelLimitDiv->doUpdate && !$this->wholePixcelLimitDiv->isIdentity)$fields[] = $this->wholePixcelLimitDiv;
        if($this->wholePixcelLimitSeq->doUpdate && !$this->wholePixcelLimitSeq->isIdentity)$fields[] = $this->wholePixcelLimitSeq;
        if($this->adPixcelX->doUpdate && !$this->adPixcelX->isIdentity)$fields[] = $this->adPixcelX;
        if($this->adPixcelY->doUpdate && !$this->adPixcelY->isIdentity)$fields[] = $this->adPixcelY;
        if($this->adPixcelLimit->doUpdate && !$this->adPixcelLimit->isIdentity)$fields[] = $this->adPixcelLimit;
        if($this->adPixcelLimitDiv->doUpdate && !$this->adPixcelLimitDiv->isIdentity)$fields[] = $this->adPixcelLimitDiv;
        if($this->adPixcelLimitSeq->doUpdate && !$this->adPixcelLimitSeq->isIdentity)$fields[] = $this->adPixcelLimitSeq;
        if($this->rfPixcelX->doUpdate && !$this->rfPixcelX->isIdentity)$fields[] = $this->rfPixcelX;
        if($this->rfPixcelY->doUpdate && !$this->rfPixcelY->isIdentity)$fields[] = $this->rfPixcelY;
        if($this->rfPixcelLimit->doUpdate && !$this->rfPixcelLimit->isIdentity)$fields[] = $this->rfPixcelLimit;
        if($this->rfPixcelLimitDiv->doUpdate && !$this->rfPixcelLimitDiv->isIdentity)$fields[] = $this->rfPixcelLimitDiv;
        if($this->rfPixcelLimitSeq->doUpdate && !$this->rfPixcelLimitSeq->isIdentity)$fields[] = $this->rfPixcelLimitSeq;
        if($this->colorCapacity->doUpdate && !$this->colorCapacity->isIdentity)$fields[] = $this->colorCapacity;
        if($this->colorCapacityLimit->doUpdate && !$this->colorCapacityLimit->isIdentity)$fields[] = $this->colorCapacityLimit;
        if($this->colorCapacityLimitDiv->doUpdate && !$this->colorCapacityLimitDiv->isIdentity)$fields[] = $this->colorCapacityLimitDiv;
        if($this->colorCapacityLimitSeq->doUpdate && !$this->colorCapacityLimitSeq->isIdentity)$fields[] = $this->colorCapacityLimitSeq;
        if($this->monoCapacity->doUpdate && !$this->monoCapacity->isIdentity)$fields[] = $this->monoCapacity;
        if($this->monoCapacityLimit->doUpdate && !$this->monoCapacityLimit->isIdentity)$fields[] = $this->monoCapacityLimit;
        if($this->monoCapacityLimitDiv->doUpdate && !$this->monoCapacityLimitDiv->isIdentity)$fields[] = $this->monoCapacityLimitDiv;
        if($this->monoCapacityLimitSeq->doUpdate && !$this->monoCapacityLimitSeq->isIdentity)$fields[] = $this->monoCapacityLimitSeq;
        if($this->mainLetterFlag->doUpdate && !$this->mainLetterFlag->isIdentity)$fields[] = $this->mainLetterFlag;
        if($this->mainLetter->doUpdate && !$this->mainLetter->isIdentity)$fields[] = $this->mainLetter;
        if($this->mLetterLimit->doUpdate && !$this->mLetterLimit->isIdentity)$fields[] = $this->mLetterLimit;
        if($this->mLetterLimitDiv->doUpdate && !$this->mLetterLimitDiv->isIdentity)$fields[] = $this->mLetterLimitDiv;
        if($this->mLetterLimitSeq->doUpdate && !$this->mLetterLimitSeq->isIdentity)$fields[] = $this->mLetterLimitSeq;
        if($this->mainLine->doUpdate && !$this->mainLine->isIdentity)$fields[] = $this->mainLine;
        if($this->mLineLimit->doUpdate && !$this->mLineLimit->isIdentity)$fields[] = $this->mLineLimit;
        if($this->mLineLimitDiv->doUpdate && !$this->mLineLimitDiv->isIdentity)$fields[] = $this->mLineLimitDiv;
        if($this->mLineLimitSeq->doUpdate && !$this->mLineLimitSeq->isIdentity)$fields[] = $this->mLineLimitSeq;
        if($this->m2bytecharFlag->doUpdate && !$this->m2bytecharFlag->isIdentity)$fields[] = $this->m2bytecharFlag;
        if($this->m1bytecharFlag->doUpdate && !$this->m1bytecharFlag->isIdentity)$fields[] = $this->m1bytecharFlag;
        if($this->mKanaFlag->doUpdate && !$this->mKanaFlag->isIdentity)$fields[] = $this->mKanaFlag;
        if($this->mRfFlag->doUpdate && !$this->mRfFlag->isIdentity)$fields[] = $this->mRfFlag;
        if($this->mRfRemarks->doUpdate && !$this->mRfRemarks->isIdentity)$fields[] = $this->mRfRemarks;
        if($this->mPictureCharFlag->doUpdate && !$this->mPictureCharFlag->isIdentity)$fields[] = $this->mPictureCharFlag;
        if($this->mPictureCharExtendFlag->doUpdate && !$this->mPictureCharExtendFlag->isIdentity)$fields[] = $this->mPictureCharExtendFlag;
        if($this->titleLetterFlag->doUpdate && !$this->titleLetterFlag->isIdentity)$fields[] = $this->titleLetterFlag;
        if($this->titelLetter->doUpdate && !$this->titelLetter->isIdentity)$fields[] = $this->titelLetter;
        if($this->tLetterLimit->doUpdate && !$this->tLetterLimit->isIdentity)$fields[] = $this->tLetterLimit;
        if($this->tLetterLimitDiv->doUpdate && !$this->tLetterLimitDiv->isIdentity)$fields[] = $this->tLetterLimitDiv;
        if($this->tLetterLimitSeq->doUpdate && !$this->tLetterLimitSeq->isIdentity)$fields[] = $this->tLetterLimitSeq;
        if($this->tLine->doUpdate && !$this->tLine->isIdentity)$fields[] = $this->tLine;
        if($this->tLineLimit->doUpdate && !$this->tLineLimit->isIdentity)$fields[] = $this->tLineLimit;
        if($this->tLineLimitDiv->doUpdate && !$this->tLineLimitDiv->isIdentity)$fields[] = $this->tLineLimitDiv;
        if($this->tLineLimitSeq->doUpdate && !$this->tLineLimitSeq->isIdentity)$fields[] = $this->tLineLimitSeq;
        if($this->t2bytecharFlag->doUpdate && !$this->t2bytecharFlag->isIdentity)$fields[] = $this->t2bytecharFlag;
        if($this->t1bytecharFlag->doUpdate && !$this->t1bytecharFlag->isIdentity)$fields[] = $this->t1bytecharFlag;
        if($this->tKanaFlag->doUpdate && !$this->tKanaFlag->isIdentity)$fields[] = $this->tKanaFlag;
        if($this->tRfFlag->doUpdate && !$this->tRfFlag->isIdentity)$fields[] = $this->tRfFlag;
        if($this->tRfRemarks->doUpdate && !$this->tRfRemarks->isIdentity)$fields[] = $this->tRfRemarks;
        if($this->tPictureCharFlag->doUpdate && !$this->tPictureCharFlag->isIdentity)$fields[] = $this->tPictureCharFlag;
        if($this->tPictureCharExtendFlag->doUpdate && !$this->tPictureCharExtendFlag->isIdentity)$fields[] = $this->tPictureCharExtendFlag;
        if($this->urlFlag->doUpdate && !$this->urlFlag->isIdentity)$fields[] = $this->urlFlag;
        if($this->urlLetter->doUpdate && !$this->urlLetter->isIdentity)$fields[] = $this->urlLetter;
        if($this->uLetterLimit->doUpdate && !$this->uLetterLimit->isIdentity)$fields[] = $this->uLetterLimit;
        if($this->uLetterLimitDiv->doUpdate && !$this->uLetterLimitDiv->isIdentity)$fields[] = $this->uLetterLimitDiv;
        if($this->uLetterLimitSeq->doUpdate && !$this->uLetterLimitSeq->isIdentity)$fields[] = $this->uLetterLimitSeq;
        if($this->altFlag->doUpdate && !$this->altFlag->isIdentity)$fields[] = $this->altFlag;
        if($this->altLetter->doUpdate && !$this->altLetter->isIdentity)$fields[] = $this->altLetter;
        if($this->aLetterLimit->doUpdate && !$this->aLetterLimit->isIdentity)$fields[] = $this->aLetterLimit;
        if($this->aLetterLimitDiv->doUpdate && !$this->aLetterLimitDiv->isIdentity)$fields[] = $this->aLetterLimitDiv;
        if($this->aLetterLimitSeq->doUpdate && !$this->aLetterLimitSeq->isIdentity)$fields[] = $this->aLetterLimitSeq;
        if($this->a2bytecharFlag->doUpdate && !$this->a2bytecharFlag->isIdentity)$fields[] = $this->a2bytecharFlag;
        if($this->a1bytecharFlag->doUpdate && !$this->a1bytecharFlag->isIdentity)$fields[] = $this->a1bytecharFlag;
        if($this->aKanaFlag->doUpdate && !$this->aKanaFlag->isIdentity)$fields[] = $this->aKanaFlag;
        if($this->loopLimitFlag->doUpdate && !$this->loopLimitFlag->isIdentity)$fields[] = $this->loopLimitFlag;
        if($this->lCount->doUpdate && !$this->lCount->isIdentity)$fields[] = $this->lCount;
        if($this->lCountOpenFlag->doUpdate && !$this->lCountOpenFlag->isIdentity)$fields[] = $this->lCountOpenFlag;
        if($this->lRoundLimitFlag->doUpdate && !$this->lRoundLimitFlag->isIdentity)$fields[] = $this->lRoundLimitFlag;
        if($this->lRoundSecond->doUpdate && !$this->lRoundSecond->isIdentity)$fields[] = $this->lRoundSecond;
        if($this->lRoundLimit->doUpdate && !$this->lRoundLimit->isIdentity)$fields[] = $this->lRoundLimit;
        if($this->lRoundLimitDiv->doUpdate && !$this->lRoundLimitDiv->isIdentity)$fields[] = $this->lRoundLimitDiv;
        if($this->lRoundLimitSeq->doUpdate && !$this->lRoundLimitSeq->isIdentity)$fields[] = $this->lRoundLimitSeq;
        if($this->animationFlag->doUpdate && !$this->animationFlag->isIdentity)$fields[] = $this->animationFlag;
        if($this->animationCount->doUpdate && !$this->animationCount->isIdentity)$fields[] = $this->animationCount;
        if($this->colorFlag->doUpdate && !$this->colorFlag->isIdentity)$fields[] = $this->colorFlag;
        if($this->withMonoFlag->doUpdate && !$this->withMonoFlag->isIdentity)$fields[] = $this->withMonoFlag;
        if($this->dhtmlFlag->doUpdate && !$this->dhtmlFlag->isIdentity)$fields[] = $this->dhtmlFlag;
        if($this->linkTarget->doUpdate && !$this->linkTarget->isIdentity)$fields[] = $this->linkTarget;
        if($this->pcCharFlag->doUpdate && !$this->pcCharFlag->isIdentity)$fields[] = $this->pcCharFlag;
        if($this->soundFlag->doUpdate && !$this->soundFlag->isIdentity)$fields[] = $this->soundFlag;
        if($this->soundDefaultFlag->doUpdate && !$this->soundDefaultFlag->isIdentity)$fields[] = $this->soundDefaultFlag;
        if($this->mutebuttonFlag->doUpdate && !$this->mutebuttonFlag->isIdentity)$fields[] = $this->mutebuttonFlag;
        if($this->closebuttonFlag->doUpdate && !$this->closebuttonFlag->isIdentity)$fields[] = $this->closebuttonFlag;
        if($this->encode->doUpdate && !$this->encode->isIdentity)$fields[] = $this->encode;
        if($this->encodeDiv->doUpdate && !$this->encodeDiv->isIdentity)$fields[] = $this->encodeDiv;
        if($this->encodeSeq->doUpdate && !$this->encodeSeq->isIdentity)$fields[] = $this->encodeSeq;
        if($this->bitRateMin->doUpdate && !$this->bitRateMin->isIdentity)$fields[] = $this->bitRateMin;
        if($this->bitRateMax->doUpdate && !$this->bitRateMax->isIdentity)$fields[] = $this->bitRateMax;
        if($this->soundEncode->doUpdate && !$this->soundEncode->isIdentity)$fields[] = $this->soundEncode;
        if($this->soundEncodeDiv->doUpdate && !$this->soundEncodeDiv->isIdentity)$fields[] = $this->soundEncodeDiv;
        if($this->soundEncodeSeq->doUpdate && !$this->soundEncodeSeq->isIdentity)$fields[] = $this->soundEncodeSeq;
        if($this->soundBitRateMin->doUpdate && !$this->soundBitRateMin->isIdentity)$fields[] = $this->soundBitRateMin;
        if($this->soundBitRateMax->doUpdate && !$this->soundBitRateMax->isIdentity)$fields[] = $this->soundBitRateMax;
        if($this->soundEncodeVersion->doUpdate && !$this->soundEncodeVersion->isIdentity)$fields[] = $this->soundEncodeVersion;
        if($this->startAreaRemarks->doUpdate && !$this->startAreaRemarks->isIdentity)$fields[] = $this->startAreaRemarks;
        if($this->flaFileVersion->doUpdate && !$this->flaFileVersion->isIdentity)$fields[] = $this->flaFileVersion;
        if($this->flaFileMustFlag->doUpdate && !$this->flaFileMustFlag->isIdentity)$fields[] = $this->flaFileMustFlag;
        if($this->flaFilePublishFlag->doUpdate && !$this->flaFilePublishFlag->isIdentity)$fields[] = $this->flaFilePublishFlag;
        if($this->mustFlag->doUpdate && !$this->mustFlag->isIdentity)$fields[] = $this->mustFlag;
        if($this->remarks->doUpdate && !$this->remarks->isIdentity)$fields[] = $this->remarks;
        if($this->regPtnNo->doUpdate && !$this->regPtnNo->isIdentity)$fields[] = $this->regPtnNo;
        if($this->useMenuCarrierFlag->doUpdate && !$this->useMenuCarrierFlag->isIdentity)$fields[] = $this->useMenuCarrierFlag;
        if($this->admissionAdCode->doUpdate && !$this->admissionAdCode->isIdentity)$fields[] = $this->admissionAdCode;
        if($this->materialPatternSeq->doUpdate && !$this->materialPatternSeq->isIdentity)$fields[] = $this->materialPatternSeq;
        if($this->specialFlag->doUpdate && !$this->specialFlag->isIdentity)$fields[] = $this->specialFlag;
        if($this->validFlag->doUpdate && !$this->validFlag->isIdentity)$fields[] = $this->validFlag;
        if($this->insertDateTime->doUpdate && !$this->insertDateTime->isIdentity)$fields[] = $this->insertDateTime;
        if($this->insertOperatorCode->doUpdate && !$this->insertOperatorCode->isIdentity)$fields[] = $this->insertOperatorCode;
        if($this->updateDateTime->doUpdate && !$this->updateDateTime->isIdentity)$fields[] = $this->updateDateTime;
        if($this->operatorCode->doUpdate && !$this->operatorCode->isIdentity)$fields[] = $this->operatorCode;
        
        return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
        $this->siteCode->doUpdate = $doUpdate;
        $this->menuCode->doUpdate = $doUpdate;
        $this->manuscriptSeq->doUpdate = $doUpdate;
        $this->seq->doUpdate = $doUpdate;
        $this->materialCode->doUpdate = $doUpdate;
        $this->materialAliasName->doUpdate = $doUpdate;
        $this->materialInputKindDiv->doUpdate = $doUpdate;
        $this->materialInputKindSeq->doUpdate = $doUpdate;
        $this->fileVersion->doUpdate = $doUpdate;
        $this->fileExtention->doUpdate = $doUpdate;
        $this->wholePixcelX->doUpdate = $doUpdate;
        $this->wholePixcelY->doUpdate = $doUpdate;
        $this->wholePixcelLimit->doUpdate = $doUpdate;
        $this->wholePixcelLimitDiv->doUpdate = $doUpdate;
        $this->wholePixcelLimitSeq->doUpdate = $doUpdate;
        $this->adPixcelX->doUpdate = $doUpdate;
        $this->adPixcelY->doUpdate = $doUpdate;
        $this->adPixcelLimit->doUpdate = $doUpdate;
        $this->adPixcelLimitDiv->doUpdate = $doUpdate;
        $this->adPixcelLimitSeq->doUpdate = $doUpdate;
        $this->rfPixcelX->doUpdate = $doUpdate;
        $this->rfPixcelY->doUpdate = $doUpdate;
        $this->rfPixcelLimit->doUpdate = $doUpdate;
        $this->rfPixcelLimitDiv->doUpdate = $doUpdate;
        $this->rfPixcelLimitSeq->doUpdate = $doUpdate;
        $this->colorCapacity->doUpdate = $doUpdate;
        $this->colorCapacityLimit->doUpdate = $doUpdate;
        $this->colorCapacityLimitDiv->doUpdate = $doUpdate;
        $this->colorCapacityLimitSeq->doUpdate = $doUpdate;
        $this->monoCapacity->doUpdate = $doUpdate;
        $this->monoCapacityLimit->doUpdate = $doUpdate;
        $this->monoCapacityLimitDiv->doUpdate = $doUpdate;
        $this->monoCapacityLimitSeq->doUpdate = $doUpdate;
        $this->mainLetterFlag->doUpdate = $doUpdate;
        $this->mainLetter->doUpdate = $doUpdate;
        $this->mLetterLimit->doUpdate = $doUpdate;
        $this->mLetterLimitDiv->doUpdate = $doUpdate;
        $this->mLetterLimitSeq->doUpdate = $doUpdate;
        $this->mainLine->doUpdate = $doUpdate;
        $this->mLineLimit->doUpdate = $doUpdate;
        $this->mLineLimitDiv->doUpdate = $doUpdate;
        $this->mLineLimitSeq->doUpdate = $doUpdate;
        $this->m2bytecharFlag->doUpdate = $doUpdate;
        $this->m1bytecharFlag->doUpdate = $doUpdate;
        $this->mKanaFlag->doUpdate = $doUpdate;
        $this->mRfFlag->doUpdate = $doUpdate;
        $this->mRfRemarks->doUpdate = $doUpdate;
        $this->mPictureCharFlag->doUpdate = $doUpdate;
        $this->mPictureCharExtendFlag->doUpdate = $doUpdate;
        $this->titleLetterFlag->doUpdate = $doUpdate;
        $this->titelLetter->doUpdate = $doUpdate;
        $this->tLetterLimit->doUpdate = $doUpdate;
        $this->tLetterLimitDiv->doUpdate = $doUpdate;
        $this->tLetterLimitSeq->doUpdate = $doUpdate;
        $this->tLine->doUpdate = $doUpdate;
        $this->tLineLimit->doUpdate = $doUpdate;
        $this->tLineLimitDiv->doUpdate = $doUpdate;
        $this->tLineLimitSeq->doUpdate = $doUpdate;
        $this->t2bytecharFlag->doUpdate = $doUpdate;
        $this->t1bytecharFlag->doUpdate = $doUpdate;
        $this->tKanaFlag->doUpdate = $doUpdate;
        $this->tRfFlag->doUpdate = $doUpdate;
        $this->tRfRemarks->doUpdate = $doUpdate;
        $this->tPictureCharFlag->doUpdate = $doUpdate;
        $this->tPictureCharExtendFlag->doUpdate = $doUpdate;
        $this->urlFlag->doUpdate = $doUpdate;
        $this->urlLetter->doUpdate = $doUpdate;
        $this->uLetterLimit->doUpdate = $doUpdate;
        $this->uLetterLimitDiv->doUpdate = $doUpdate;
        $this->uLetterLimitSeq->doUpdate = $doUpdate;
        $this->altFlag->doUpdate = $doUpdate;
        $this->altLetter->doUpdate = $doUpdate;
        $this->aLetterLimit->doUpdate = $doUpdate;
        $this->aLetterLimitDiv->doUpdate = $doUpdate;
        $this->aLetterLimitSeq->doUpdate = $doUpdate;
        $this->a2bytecharFlag->doUpdate = $doUpdate;
        $this->a1bytecharFlag->doUpdate = $doUpdate;
        $this->aKanaFlag->doUpdate = $doUpdate;
        $this->loopLimitFlag->doUpdate = $doUpdate;
        $this->lCount->doUpdate = $doUpdate;
        $this->lCountOpenFlag->doUpdate = $doUpdate;
        $this->lRoundLimitFlag->doUpdate = $doUpdate;
        $this->lRoundSecond->doUpdate = $doUpdate;
        $this->lRoundLimit->doUpdate = $doUpdate;
        $this->lRoundLimitDiv->doUpdate = $doUpdate;
        $this->lRoundLimitSeq->doUpdate = $doUpdate;
        $this->animationFlag->doUpdate = $doUpdate;
        $this->animationCount->doUpdate = $doUpdate;
        $this->colorFlag->doUpdate = $doUpdate;
        $this->withMonoFlag->doUpdate = $doUpdate;
        $this->dhtmlFlag->doUpdate = $doUpdate;
        $this->linkTarget->doUpdate = $doUpdate;
        $this->pcCharFlag->doUpdate = $doUpdate;
        $this->soundFlag->doUpdate = $doUpdate;
        $this->soundDefaultFlag->doUpdate = $doUpdate;
        $this->mutebuttonFlag->doUpdate = $doUpdate;
        $this->closebuttonFlag->doUpdate = $doUpdate;
        $this->encode->doUpdate = $doUpdate;
        $this->encodeDiv->doUpdate = $doUpdate;
        $this->encodeSeq->doUpdate = $doUpdate;
        $this->bitRateMin->doUpdate = $doUpdate;
        $this->bitRateMax->doUpdate = $doUpdate;
        $this->soundEncode->doUpdate = $doUpdate;
        $this->soundEncodeDiv->doUpdate = $doUpdate;
        $this->soundEncodeSeq->doUpdate = $doUpdate;
        $this->soundBitRateMin->doUpdate = $doUpdate;
        $this->soundBitRateMax->doUpdate = $doUpdate;
        $this->soundEncodeVersion->doUpdate = $doUpdate;
        $this->startAreaRemarks->doUpdate = $doUpdate;
        $this->flaFileVersion->doUpdate = $doUpdate;
        $this->flaFileMustFlag->doUpdate = $doUpdate;
        $this->flaFilePublishFlag->doUpdate = $doUpdate;
        $this->mustFlag->doUpdate = $doUpdate;
        $this->remarks->doUpdate = $doUpdate;
        $this->regPtnNo->doUpdate = $doUpdate;
        $this->useMenuCarrierFlag->doUpdate = $doUpdate;
        $this->admissionAdCode->doUpdate = $doUpdate;
        $this->materialPatternSeq->doUpdate = $doUpdate;
        $this->specialFlag->doUpdate = $doUpdate;
        $this->validFlag->doUpdate = $doUpdate;
        $this->insertDateTime->doUpdate = $doUpdate;
        $this->insertOperatorCode->doUpdate = $doUpdate;
        $this->updateDateTime->doUpdate = $doUpdate;
        $this->operatorCode->doUpdate = $doUpdate;
        
    }

    
}
