<?php
include("../../startup.php");
Zend_Loader::loadClass("CFW_Sample_Models_UsersModel");
Zend_Loader::loadClass("CFW_Sample_Models_UsersEntity");
Zend_Loader::loadClass("CFW_Models_Base");
Zend_Loader::loadClass("CFW_Util_Html");
Zend_Loader::loadClass("CFW_Util_Date");
Zend_Loader::loadClass("CFW_Util_Number");
Zend_Loader::loadClass("CFW_Util_String");

if(!array_key_exists("userId",$_GET)){
    die("user id must be specified");
}

$user = null;
if(array_key_exists("submit",$_POST)){
    $user = new CFW_Sample_Models_UsersEntity();
    $user->userId = CFW_Util_String::toString($_POST["userId"]);
    $user->password = CFW_Util_String::toString($_POST["password"]);
    $user->userName = CFW_Util_String::toString($_POST["userName"]);
    $user->numFields = CFW_Util_Number::toNumber($_POST["numFields"]);
    $user->birthday= CFW_Util_Date::format( CFW_Util_Date::parse($_POST["birthday"]));
    $user->isNew = false;
    $user->isModified= true;
    $user->isDeleted = false;
    $model = new CFW_Sample_Models_UsersModel();
    $result = $model->save($user);

}
else{
    $model = new CFW_Sample_Models_UsersModel();
    $key = new CFW_Sample_Models_UsersEntity();
    $key->userId = $_GET["userId"];
    $user = $model->load($key);

}






?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>users list</title>
<style>
table{
    border : 1px silver solid;
    border-collapse: collapse;
}
table td{
    margin : 2px;
    border : 1px silver solid;
}

</style>
</head>
<body>
<div>
<form id="form1" method="POST" />
<?php if($user!= null):?>
<table>
<tbody>
<tr><td>user id</td>
<td><input type='text' id='userId' name='userId' value='<?php echo CFW_Util_Html::escape($user->userId); ?>' /></td></tr>
<tr><td>password</td><td><input type="text" id="password" name="password" value="<?php echo CFW_Util_Html::escape($user->password);?>" /></td></tr>
<tr><td>user name</td><td><input type="text" id="userName" name="userName" value="<?php echo CFW_Util_Html::escape($user->userName);?>" /></td></tr>
<tr><td>num fields</td><td><input type="text" id="numFields" name="numFields" value="<?php echo CFW_Util_Html::escape($user->numFields);?>" /></td></tr>
<tr><td>birthdae</td><td><input type="text" id="birthday" name="birthday" value="<?php echo CFW_Util_Html::escape(CFW_Util_Date::format($user->birthday));?>" /></td></tr>
<tr><td>created at</td><td><?php echo CFW_Util_Html::escape(CFW_Util_Date::format($user->createdAt,"Y/m/d"));?></td></tr>
<tr><td>modified at</td><td><?php echo CFW_Util_Html::escape(CFW_Util_Date::format($user->modifiedAt));?></td></tr>

</tbody>
</table>
<input type="submit" name="submit" id="submit" value="送信" />
<?php else:?>
notfound;
<?php endif;?>
</form>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>