<?php
include( "../core.php" );

/**
 * LDAP filter parse
 * 再帰下降型
 * Tokenizerを使う
 * 
 * BNF
 * <filter> ::= '(' <filtercomp> ')'
 * <filtercomp> ::= <and> | <or> | <not> | <simple>
 * <and> ::= '&' <filterlist>
 * <or> ::= '|' <filterlist>
 * <not> ::= '!' <filter>
 * <filterlist> ::= <filter> | <filter> <filterlist>
 * <simple> ::= <attributetype> <filtertype> <attributevalue>
 * <filtertype> ::= '=' | '~=' | '<=' | '>='
 * @author okada
 */


/**
 * 
 * @author okada
 *
 */
class Filter{
    var $filterComp;

    public function __construct(){
        $this->filterComp = null;
    }
    public function parse(&$tokenizer){
        if ($tokenizer->token == '(') {
            $tokenizer->nextToken();
            
            $expr = new FilterComp();
            $this->filterComp = $expr->parse($tokenizer);
            $tokenizer->nextToken(); //skip last ")"
            return $this;
        }
        else{
            //error
            die("parse error");
        }
        
        return $this;
        
    }
    function dump(){
        $s = "";
        foreach($this->filterComp as $c ){
            if($s != "") $s .= " "; 
            $s .= $c->dump();
        }
        return  " ( " . $this->filterComp->dump()  . " ) ";
    }
}
class FilterComp{
    var $comp;

    public function __construct(){
        $this->comp= null;
    }
    public function parse(&$tokenizer){
        if($tokenizer->token == "&"){
            $comp = new AndComp();
            $this->comp = $comp->parse($tokenizer);
        }
        else if($tokenizer->token == "|"){
            $comp = new OrComp();
            $this->comp = $comp->parse($tokenizer);
        }
        else if($tokenizer->token == "!"){
            $comp = new NotComp();
            $this->comp = $comp->parse($tokenizer);
            
        }
        else{
            //simple
            $comp = new SimpleComp();
            $this->comp = $comp->parse($tokenizer);
        }
        return $this;
        
    }
    function dump(){
        return   $this->comp->dump()  ;
    }
    
}
class AndComp{
    var $filterList ;
    public function __construct(){
        $this->filterList = null;
    }
    public function parse(&$tokenizer){
         $tokenizer->nextToken();
         $list = new FilterList();
         $this->filterList = $list->parse($tokenizer);
         
         return $this;
         
    }
    function dump(){
        return "&". $this->filterList->dump();
    }
    
}
class OrComp{
    var $filterList ;
    public function __construct(){
        $this->filterList = null;
    }
    public function parse(&$tokenizer){
         $tokenizer->nextToken();
         $list = new FilterList();
         $this->filterList = $list->parse($tokenizer);
         
         return $this;
         
    }
    function dump(){
        return "|". $this->filterList->dump();
    }
    
        
}
class NotComp{
    var $filter;
    public function __construct(){
        $this->filter= null;
    }
    public function parse(&$tokenizer){
         $tokenizer->nextToken();
         $list = new Filter();
         $this->filter= $list->parse($tokenizer);
         
         return $this;
         
    }
    function dump(){
        return "!". $this->filter->dump();
    }
    
    }
class FilterList{
    var $filter;
    public function __construct(){
        $this->filter = array();
    }
    public function parse(&$tokenizer){
        //最初の1個
        $expr = new Filter();
        $this->filter[] = $expr->parse($tokenizer);
        
        while($tokenizer->token == "("){
            $expr = new Filter();
            $this->filter[] = $expr->parse($tokenizer);
            
        }
        return $this;
        
    }
    function dump(){
        $s = "";
        foreach($this->filter as $filter){
            $s .= $filter->dump();
        }
        return  $s; 
    }
    
    
}
class SimpleComp{
    var $attributeType;
    var $filterType;
    var $attributeValue;
    public function __construct(){
    }
    public function parse(&$tokenizer){
        $this->attributeType = $tokenizer->token;
        $tokenizer->nextToken();
        $this->filterType = $tokenizer->token;
        $tokenizer->nextToken();
        $this->attributeValue = $tokenizer->token;
        $tokenizer->nextToken();
        
        return $this;
    }
    function dump(){
        return $this->attributeType . " " . $this->filterType . " " . $this->attributeValue;
    }
    
    
}

class Parser{
    var $result;
    var $tokenizer;
    var $currentToken ;
    function __construct(){
    }
    public function parse($s){
        $this->tokenizer = new CFW_Common_Tokenizer(new CFW_IO_StringReader( $s ));
        $this->tokenizer->operator = array("&","|","!","=","(",")");
        $this->currentToken = $this->tokenizer->nextToken();
        $expr = new Filter();
        $this->result = $expr->parse($this->tokenizer);
        
    }
    
    
    
}

$parser = new Parser();
$parser->parse("(a=b)");
echo "-----<br />";
echo "result = " . $parser->result->dump(). "<br />";
var_dump($parser->result);
echo "-----<br />";
$parser->parse("(&(a=b)(c=d))");
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("(|(&(a=b)(c=d))(e=f))");
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";

?>