<?php
/**
 * エラーを表現する。
 * <p>エラー追跡ID,エラーの詳細を格納して他システムなどに送信できるようにする。</p>
 * @author okada
 * @package CFW_Error
 */
class CFW_Error_Message{
    /**
     * @var int オブジェクトを特定するためのID.外から設定する
     */
    public $id;

    /**
     * @var string エラーが起こったファイル
     */
    public $fileName;
    /**
     * @var string エラーが起こったクラス
     */
    public $className;
    /**
     *
     * @var string エラーが起こった関数(クラスの内部ならメソッド)
     */
    public $functionName;
    /**
     * @var string エラーの詳細
     */
    public $description;

    /**
     * @param string $fileName クラス名(__FILE__)を指定
     * @param string $className クラス名(__CLASS__)を指定
     * @param string $functionName 関数名(クラスの メソッドの場合メソッド名)(__FUNCTION__)を指定
     * @param string $description エラーの詳細
     * @return unknown_type
     */
    public function __construct($fileName,$className,$functionName,$description = ""){
        $this->id = "";
        $this->fileName = basename($fileName);
        $this->className = $className;
        $this->functionName= $functionName;
        $this->description = $description;
    }
}