<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Amf_AppKey");
Zend_Loader::loadClass("CFW_Util_Cache");
Zend_Loader::loadClass("CFW_Util_String");

/**
 * アプリケーションキー発行機能

 * <p>許可されたAIRアプリケーションからAMFサービスを使用させるために、AIRアプリケーションが起動する時にappkeyを発行し、その後のAMFサービス呼び出しはappkeyを使って認証する。</p>
 * <p>これによりappkeyを発行されていないアプリケーションのAMFサービス使用を拒否する。</p>
 * <p>appkey発行時のユーザー、パスワードが発覚してもそれを使ってappkey.php以外の呼び出しても認証失敗に終わる。</p>
 * @author okada
 * @package CFW_Amf
 */
class CFW_Amf_AppKeyGenerator{
    var $config;
    var $logger;
    var $appkeyConfig;
    public function __construct(){
        $coreconfig = CFW_Config_Configuration::getInstance("core");
        $this->appkeyConfig = $coreconfig->amf->appkey;
        $this->config = $coreconfig->amf->appkey;
        $this->logger = CFW_Log_LoggerFactory::getLogger("default",__CLASS__);
    }
    /**
     * リモートアドレスと現在時間でアプリケーションキーを作成
     * @return mixed
     */
    public function generate(){
        $remoteAddress = $_SERVER["REMOTE_ADDR"];
        $now = new DateTime();

        $this->logger->info(__FUNCTION__,"called from" . $remoteAddress);
        $id = md5( $now->format("YmdHisu").$remoteAddress );
        $password = md5( CFW_Util_String::randomString(16) );
        $appkey = new CFW_Amf_AppKey($id,$password,$remoteAddress);

        $cacheConfig = $this->config->cache;
        $cache = CFW_Util_Cache::factory($cacheConfig->toArray());
        $cache->save($appkey,$id);

        $this->logger->info(__FUNCTION__,"generated key " . $id);
        return $appkey;

    }
    /**
     * 入力されたID,パスワードを検証する。
     * @param unknown_type $id
     * @param unknown_type $password
     * @return bool
     */
    public function validate($id,$password){
        $cache = CFW_Util_Cache::factory($config->cache);
        $appkey = $cache->load($id);
        if($appkey == null) return false;
        if(($id == $appkey["id"])&&($id == $appkey["password"])){
            $cache->save($appkey,$appkey["id"]); //キャッシュの有効期限を更新する
            return true;
        }
        return false;

    }
}