<?php
require_once ("File.php");
require_once ("File/Util.php");
/**
 * ファイルシステム関数のショートカット
 * @author okada
 * @package CFW_IO
 */
class CFW_IO_FileSystem{
    /**
     * @var CFW_IO_FileSystem 唯一のファイルシステム
     */
    static $fileSystem = null;
    var $config;
    /**
     * 使用可能なファイルシステムを得る
     * @return CFW_IO_FileSystem 使用できるファイルシステム
     */
    public static function getInstance(){
        if(self::$fileSystem == null){
            self::$fileSystem = new CFW_IO_FileSystem();
            self::$fileSystem->config = CFW_Config_Configuration::getInstance("core")->filesystem;

        }
        return self::$fileSystem;
    }
	/**
	 * ディレクトリ作成
	 *
	 * $direSpecで指定したディレクトリ定義に基づき実ディレクトリを作成し、作成したディレクトリ名を返す
	 * @param $baseDir 基準ディレクトリ 必ず存在し、書き込めなければならない
	 * @param $dirSpec 追加ディレクトリの定義 配列
	 * @return String 作成したディレクトリ名
	 */
	public function createDirectory($baseDir,$dirSpec = array()){

		$b = split(addslashes(DS),$baseDir);
		$path = "";
		foreach($b as $bb){
            $path = File_Util::buildPath(array($path,$bb));
            if(!file_exists($path)){
                mkdir($path);
            }

		}

		foreach($dirSpec as $dir){
			$path = File_Util::buildPath(array($path,$dir));
			if(!file_exists($path)){
				mkdir($path);
			}
		}
		return $path;
	}
	/**
	 * 渡されたパスを解決する
	 *
	 * 渡されたパスが相対ディレクトリの場合BASE_DIRを基準としたパスを返す。
	 * 絶対パスの場合はそのパスをそのまま返す。
	 * パスのディレクトリが無ければ作成する。
	 * @param unknown_type $path
	 * @return unknown_type
	 */
	public function resolvePath($path){
        if(File_Util::isAbsolute($path)){
            return $path;
        }
        else{
            $realpath = BASE_PATH.DS.$path;
            return realpath($realpath);
        }
        return BASE_PATH;
	}
	public function getContent($path){

	    $file = new File();
	    return $file->readAll($path);
	}
	/**
	 * 一時ディレクトリ
	 * <p>設定ファイルに記述された一時ディレクトリか、$TEMP,$TMPなど環境変数に設定された一時ディレクトリか、%SYSTEM%/temp など</p>
	 * @return string
	 */
	public function getTempoaryDirecotry(){
	    if(isset($this->config->temporaryDirectory)){
	        return $this->config->temporaryDirectory;
	    }
        return File_Util::tmpDir( );

	}
	/**
	 * ユーザーが作るドキュメントファイルを保存する場所
	 * @return unknown_type
	 */
    public function getDocumentDirectory(){
        if(isset($this->config->documentDirectory)){
            return $this->config->documentDirectory;
        }
        return $this->getTempoaryDirecotry();
    }
    /**
     * 一時ファイル名
     * @param unknown_type $dirname (optional)指定されたらこの中に作る
     * @return string
     */
    public function getTempoaryFile($dirname = null ){
        return File_Util::tmpFile( $dirname );
    }

}
?>