<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table acl_rules Field定義
*/
class CFW_Sample_Models_Base_AclRulesTableRow extends CFW_Models_Entity
{
    /** 
    * @var Number id [id]
    */
    public $id;
    /** 
    * @var Number resourceId [resource_id]
    */
    public $resourceId;
    /** 
    * @var Number roleId [role_id]
    */
    public $roleId;
    /** 
    * @var Number Create [_create]
    */
    public $Create;
    /** 
    * @var Number Read [_read]
    */
    public $Read;
    /** 
    * @var Number Update [_update]
    */
    public $Update;
    /** 
    * @var Number Delete [_delete]
    */
    public $Delete;
    /** 
    * @var String description [description]
    */
    public $description;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->id = 0;
        $this->resourceId = null;
        $this->roleId = null;
        $this->Create = null;
        $this->Read = null;
        $this->Update = null;
        $this->Delete = null;
        $this->description = "";
        
    }
    
    /**
    * 列名を指定して値を設宁E
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "id") $this->id = CFW_Util_Number::numberValue( $value );
        if($name ==  "resource_id") $this->resourceId = CFW_Util_Number::numberValue( $value );
        if($name ==  "role_id") $this->roleId = CFW_Util_Number::numberValue( $value );
        if($name ==  "_create") $this->Create = CFW_Util_Number::numberValue( $value );
        if($name ==  "_read") $this->Read = CFW_Util_Number::numberValue( $value );
        if($name ==  "_update") $this->Update = CFW_Util_Number::numberValue( $value );
        if($name ==  "_delete") $this->Delete = CFW_Util_Number::numberValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取征E
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取征E
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "id") return $this->id;
        if($name ==  "resource_id") return $this->resourceId;
        if($name ==  "role_id") return $this->roleId;
        if($name ==  "_create") return $this->Create;
        if($name ==  "_read") return $this->Read;
        if($name ==  "_update") return $this->Update;
        if($name ==  "_delete") return $this->Delete;
        if($name ==  "description") return $this->description;
        
        return null;
    }
    
    /**
    * 持EデータからのコピE
    * @param AclRulesTableRow コピE允E
    * @return none
    */
    public function copyFrom($source)
    {
        $this->id = $source->id;
        $this->resourceId = $source->resourceId;
        $this->roleId = $source->roleId;
        $this->Create = $source->Create;
        $this->Read = $source->Read;
        $this->Update = $source->Update;
        $this->Delete = $source->Delete;
        $this->description = $source->description;
        
    }
}
