<?php
include("../../core.php");

$config = CFW_Common_Config::factory("datasource");

$source = CFW_Models_DataSource::getDataSource($config->vin101ldap);
$source->connect();

$model = new CFW_Ldap_EntryModel();
$criteria = new CFW_Ldap_Criteria();
$criteria->setBaseDn('ou=Users,dc=craft-net,dc=co,dc=jp');
$criteria->add("objectClass","*");
$criteria->addAnd("uid","*");

$entries = $source->read($model,$criteria);

$source->disconnect();

// クローズ 
echo "Closing connection"; 

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>describe columns</title>
<style>
.entry{
    margin-bottom : 1em;
    border-bottom : 1px solid #CCCCCC;
}
</style>
</head>
<body>
<div>
<?php foreach($entries as $entry):?>
    <div class="entry">
    <dl>
    <dt>dn:<?php echo $entry["dn"]?></dt>
    <dd>mail=<?php  echo htmlspecialchars($entry["mail"][0])?><br />
    cn=<?php  echo htmlspecialchars($entry["cn;lang-ja"][0])?><br />
    ou=<?php  echo htmlspecialchars($entry["ou;lang-ja"][0])?><br />
    ou=<?php  echo htmlspecialchars($entry["ou;lang-ja"][1])?><br />
    <?php var_dump($entry)?>
    </dd>
    </dl>
    </div>
<?php endforeach; ?>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>