<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Auth_Provider");
Zend_Loader::loadClass("CFW_Auth_Hash");
/**
 * 認証機能生成
 * @author okada
 * @package CFW_Auth
 */
class CFW_Auth_ProviderFactory{
	static $instance = null;
	static $authConfig = null;
	static $providerName = "";
	static $storageName = "";
	
	/**
	 * 認証プロバイダー取得
	 * @return CFW_Auth_Provider
	 */
	public static function getProvider(){
		if(self::$instance == null){
			if(self::$authConfig == null){
				$config = CFW_Config_Configuration::getInstance("core");
				self::$authConfig = $config->auth;
				self::$providerName = self::$authConfig->provider;
				self::$storageName = self::$authConfig->storage;
		        
		        
		        Zend_Loader::loadClass(self::$providerName);
		        Zend_Loader::loadClass(self::$storageName);
			}

			$provider = new self::$providerName();
			$storage = new self::$storageName();
			$provider->storage = $storage;
			$provider->config = self::$authConfig;

			$hash = CFW_Auth_Hash::getInstance(self::$authConfig->hashMethod);
			$hash->config = self::$authConfig;
			$provider->hash = $hash;
			self::$instance = $provider;
			return $provider;
		}
		return self::$instance;
		
	}
}