<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table auth_auto_login Field定義
*/
class CFW_Sample_Models_Base_AuthAutoLoginTableRow extends CFW_Models_Entity
{
    /** 
    * @var String loginId [login_id]
    */
    public $loginId;
    /** 
    * @var String randomKey [random_key]
    */
    public $randomKey;
    /** 
    * @var String identityDataType [identity_data_type]
    */
    public $identityDataType;
    /** 
    * @var String identityData [identity_data]
    */
    public $identityData;
    /** 
    * @var Date expireDate [expire_date]
    */
    public $expireDate;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->loginId = "";
        $this->randomKey = "";
        $this->identityDataType = "";
        $this->identityData = "";
        $this->expireDate = null;
        
    }
    
    /**
    * 列名を指定して値を設宁E
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "login_id") $this->loginId = CFW_Util_String::stringValue( $value );
        if($name ==  "random_key") $this->randomKey = CFW_Util_String::stringValue( $value );
        if($name ==  "identity_data_type") $this->identityDataType = CFW_Util_String::stringValue( $value );
        if($name ==  "identity_data") $this->identityData = CFW_Util_String::stringValue( $value );
        if($name ==  "expire_date") $this->expireDate = CFW_Util_Date::dateValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取征E
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取征E
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "login_id") return $this->loginId;
        if($name ==  "random_key") return $this->randomKey;
        if($name ==  "identity_data_type") return $this->identityDataType;
        if($name ==  "identity_data") return $this->identityData;
        if($name ==  "expire_date") return $this->expireDate;
        
        return null;
    }
    
    /**
    * 持EデータからのコピE
    * @param AuthAutoLoginTableRow コピE允E
    * @return none
    */
    public function copyFrom($source)
    {
        $this->loginId = $source->loginId;
        $this->randomKey = $source->randomKey;
        $this->identityDataType = $source->identityDataType;
        $this->identityData = $source->identityData;
        $this->expireDate = $source->expireDate;
        
    }
}
