<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category    ZendX
 * @package     ZendX_JQuery
 * @subpackage  View
 * @copyright   Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license     http://framework.zend.com/license/new-bsd     New BSD License
 * @version     $Id: JQuery.php 11945 2008-10-13 21:22:41Z beberlei $
 */

/**
 * jQuery Global Class holding constants and static convienience methods.
 *
 * @todo       Offer convenience methods to add a tab or accordion container/pane combination.
 * @package    ZendX_JQuery
 * @copyright  Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
  */
class ZendX_JQuery
{
    /**
     * @see http://code.google.com/apis/ajaxlibs/documentation/index.html#jquery
     * @const string Base path to CDN
     */
    const CDN_BASE_GOOGLE = 'http://ajax.googleapis.com/ajax/libs/jquery/';

    /**
     * Always uses compressed version, because this is assumed to be the use case
     * in production enviroment. An uncompressed version has to included manually.
     *
     * @see http://code.google.com/apis/ajaxlibs/documentation/index.html#jquery
     * @const string File path after base and version
     */
    const CDN_JQUERY_PATH_GOOGLE = '/jquery.min.js';

    /**
     * Which parts of the the jQuery library should be rendered on echo'ing
     * the jQuery library to the View. The constants act as bit-mask. This
     * way the jQuery autogenerated code can be refactored based on personal needs.
     *
     * @see ZendX_JQuery_Helper_JQuery::setRenderMode
     * @const Integer
     */
    const RENDER_LIBRARY         = 1;
    const RENDER_SOURCES         = 2;
    const RENDER_STYLESHEETS     = 4;
    const RENDER_JAVASCRIPT      = 8;
    const RENDER_JQUERY_ON_LOAD  = 16;
    const RENDER_ALL             = 255;

    /**
     * jQuery-enable a view instance
     *
     * @param  Zend_View_Interface $view
     * @return void
     */
    public static function enableView(Zend_View_Interface $view)
    {
        if (false === $view->getPluginLoader('helper')->getPaths('ZendX_JQuery_View_Helper')) {
            $view->addHelperPath('ZendX/JQuery/View/Helper', 'ZendX_JQuery_View_Helper');
        }
    }

    /**
     * jQuery-enable a form instance
     *
     * @param  Zend_Form $form
     * @return void
     */
    public static function enableForm(Zend_Form $form)
    {
        $form->addPrefixPath('ZendX_JQuery_Form_Decorator', 'ZendX/JQuery/Form/Decorator', 'decorator')
             ->addPrefixPath('ZendX_JQuery_Form_Element', 'ZendX/JQuery/Form/Element', 'element')
             ->addElementPrefixPath('ZendX_JQuery_Form_Decorator', 'ZendX/JQuery/Form/Decorator', 'decorator')
             ->addDisplayGroupPrefixPath('ZendX_JQuery_Form_Decorator', 'ZendX/JQuery/Form/Decorator');

        foreach ($form->getSubForms() as $subForm) {
            self::enableForm($subForm);
        }

        if (null !== ($view = $form->getView())) {
            self::enableView($view);
        }
    }
}