/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class TailIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int start;

    public static SequenceIterator make(SequenceIterator sequenceIterator, int n) throws XPathException {
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(n, Integer.MAX_VALUE);
        }
        return new TailIterator(sequenceIterator, n);
    }

    public TailIterator(SequenceIterator sequenceIterator, int n) throws XPathException {
        Item item;
        this.base = sequenceIterator;
        this.start = n;
        for (int i = 0; i < n - 1 && (item = sequenceIterator.next()) != null; ++i) {
        }
    }

    public Item next() throws XPathException {
        return this.base.next();
    }

    public Item current() {
        return this.base.current();
    }

    public int position() {
        int n = this.base.position();
        return n > 0 ? this.base.position() - this.start + 1 : n;
    }

    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    public int getLastPosition() throws XPathException {
        int n = ((LastPositionFinder)this.base).getLastPosition() - this.start + 1;
        return n > 0 ? n : 0;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new TailIterator(this.base.getAnother(), this.start);
    }

    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

