/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.tools.debugger.AbstractCellEditor;
import org.mozilla.javascript.tools.debugger.TreeTableModel;
import org.mozilla.javascript.tools.debugger.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$debugger$TreeTableModel;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$org$mozilla$javascript$tools$debugger$TreeTableModel == null ? (class$org$mozilla$javascript$tools$debugger$TreeTableModel = JTreeTable.class$("org.mozilla.javascript.tools.debugger.TreeTableModel")) : class$org$mozilla$javascript$tools$debugger$TreeTableModel, this.tree);
        this.setDefaultEditor(class$org$mozilla$javascript$tools$debugger$TreeTableModel == null ? (class$org$mozilla$javascript$tools$debugger$TreeTableModel = JTreeTable.class$("org.mozilla.javascript.tools.debugger.TreeTableModel")) : class$org$mozilla$javascript$tools$debugger$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$org$mozilla$javascript$tools$debugger$TreeTableModel == null ? (class$org$mozilla$javascript$tools$debugger$TreeTableModel = JTreeTable.class$("org.mozilla.javascript.tools.debugger.TreeTableModel")) : class$org$mozilla$javascript$tools$debugger$TreeTableModel) ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static /* synthetic */ Class class$org$mozilla$javascript$tools$debugger$TreeTableModel;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = JTreeTable.this.getColumnCount() - 1;
                while (n >= 0) {
                    if (JTreeTable.this.getColumnClass(n) == (class$org$mozilla$javascript$tools$debugger$TreeTableModel == null ? TreeTableCellEditor.class$("org.mozilla.javascript.tools.debugger.TreeTableModel") : class$org$mozilla$javascript$tools$debugger$TreeTableModel)) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        break;
                    }
                    --n;
                }
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }
}

