SELECT node.name, (COUNT(parent.name) - (sub_tree.depth + 1)) AS depth
FROM menu_item AS node,
menu_item AS parent,
menu_item AS sub_parent,
(
	SELECT node.name, (COUNT(parent.name) - 1) AS depth
	FROM menu_item AS node,
	menu_item AS parent
	WHERE node.left_side BETWEEN parent.left_side AND parent.right_side
	AND node.name = 'R[X'
	GROUP BY node.name
)AS sub_tree
WHERE node.left_side BETWEEN parent.left_side AND parent.right_side
AND node.left_side BETWEEN sub_parent.left_side AND sub_parent.right_side
AND sub_parent.name = sub_tree.name
GROUP BY node.name,node.left_side,sub_tree.depth
--HAVING (COUNT(parent.name) - (sub_tree.depth + 1)) <= 1
ORDER BY node.left_side;