using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.Script;
using OFW.Util;
using OFW.Config;
namespace OFW.AspxCommon
{
    /// <summary>
    /// ASPXy[W̒
    /// </summary>
    public abstract class AspxPage : System.Web.UI.Page
    {
        /// <summary>
        /// NCAgTChNXo^
        /// </summary>
        protected ClientClassRegister clientClassRegister;
        /// <summary>
        /// AvP[VŗLȁuÕy[WURLv擾
        /// </summary>
        /// <returns>AvP[VŗLȁuÕy[WURLv</returns>
        /// <remarks>AvP[VőJڂƂ͑JڑÕy[WURL,OTCg܂͎TCgʃAvP[VJڂƂ͋󕶎</remarks>
        public string GetAppPreviousPath()
        {
            string previousPath = string.Empty;

            if (this.Request.UrlReferrer != null)
            {
                Uri uri = new Uri(this.Request.UrlReferrer.AbsoluteUri);
                if ((uri.Host == this.Request.Url.Host) && (uri.Port == this.Request.Url.Port))
                {
                    if (uri.AbsolutePath.StartsWith(this.Request.ApplicationPath))
                    {
                        previousPath = uri.AbsolutePath;
                    }
                }
            }
            else
            {
                if (this.PreviousPage != null)
                {
                    previousPath = this.PreviousPage.Request.Path;
                }
            }
            return previousPath;

        }
        /// <summary>
        /// ^ꂽURL𑊑΃pXɕϊ
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string RelativePath(string url)
        {
            HttpContext context = HttpContext.Current;
            if (url.StartsWith("/"))
            {
                return "~" + url;
            }
            else
            {
                return url;
            }
        }
        /// <summary>
        /// ^ꂽURL΃pXɕϊ
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public string AbsolutePath(string url)
        {
            if (url.StartsWith("/"))
            {
                return this.Page.ResolveUrl("~" + url);
            }
            else
            {
                return this.Page.ResolveUrl(url);
            }
        }
        /// <summary>
        /// ݂̃hCvpeB
        /// </summary>
        /// <remarks>vpeB</remarks>
        public string CurrentDomain
        {
            get
            {
                return Request.ServerVariables["HTTP_HOST"];
            }
        }
        /// <summary>
        /// wzXgLq{̃zXg擾
        /// </summary>
        /// <param name="host"></param>
        /// <returns></returns>
        public static string getHost(string host)
        {

            int pos = host.IndexOf(":");
            if (pos < 0)
            {
                //portwȂ
                return host;
            }
            return host.Substring(0, pos);
        }
        /// <summary>
        /// t@[łB
        /// </summary>
        /// <returns></returns>
        public virtual bool isValidReferer()
        {
            string refererHost = getHost(RefererHost);

            return refererHost.EndsWith(CurrentDomain);
        }
        /// <summary>
        /// t@[̊SpX
        /// </summary>
        public string Referer
        {
            get
            {

                Uri refererUri = this.Request.UrlReferrer;
                if (refererUri == null) return "";
                return StringUtil.StringValue(refererUri.AbsoluteUri);
            }
        }
        /// <summary>
        /// t@[̃zXg
        /// </summary>
        public string RefererHost
        {
            get
            {
                Uri refererUri = this.Request.UrlReferrer;
                if (refererUri == null) return "";
                return getHost(refererUri.Host);
            }
        }
        /// <summary>
        /// URLč\z
        /// </summary>
        /// <returns></returns>
        public string RebuildCurrentUrl()
        {
            string httpHost = Request.ServerVariables["HTTP_HOST"];
            string requestUrl = StringUtil.StringValue(Request.Url.AbsoluteUri);
            int pos1 = requestUrl.IndexOf("//");
            int pos2 = requestUrl.IndexOf("/", pos1 + 2);

            string protocol = requestUrl.Substring(0, pos1); // http(s):܂œ
            string path = requestUrl.Substring(pos2); // "/"

            return protocol + "//" + httpHost + path;


        }
        /// <summary>
        /// MS ASP.NET AJAXUpdatePanelgĔ񓯊XVĂ邩ۂB
        /// </summary>
        /// <remarks>ScriptManagerIDƂScriptManager1ŒƂ</remarks>
        public bool IsInAsyncPostBack
        {
            get
            {

                ScriptManager man = ScriptManager.GetCurrent(this);
                if (man == null) return false;

                return man.IsInAsyncPostBack;

            }
        }
        /// <summary>
        /// NCAgTChŃT[o[NXƓig悤ɂ
        /// </summary>
        /// <param name="t"></param>
        public void RegisterClientClass(Type t)
        {
            if (clientClassRegister == null) clientClassRegister = new ClientClassRegister();
            clientClassRegister.RegisterClass(t);
        }
        /// <summary>
        /// NCAgTChŃT[o[l[Xy[XƓig悤ɂ
        /// </summary>
        /// <param name="n"></param>
        public void RegisterClientNameSpace(string n)
        {
            if (clientClassRegister == null) clientClassRegister = new ClientClassRegister();
            clientClassRegister.RegisterNameSpace(n);
        }
    }
}
