using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.DirectoryServices;
using OFW.Util;

namespace OFW.Auth
{
    /// <summary>
    /// AuthProviderLDAPQƎ
    /// </summary>
    /// <remarks>
    /// web.config/configulation/appSettingsɕKvȐݒ<br />
    /// <ul>
    /// <li>LdapUrl : LDAPT[o[URL</li>
    /// <li>LdapPrincipal : ̃AvP[VLDAPQƂ邽߂̃[U[DN</li>
    /// <li>LdapCredentials : ̃AvP[ṼpX[h</li>
    /// </ul>
    /// RAuthProvider̐ݒKv
    /// </remarks>
    public class LdapAuthProvider : OFW.Auth.AuthProvider
    {
        Config.ConfigFile ldapConfig;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public LdapAuthProvider()
        {
            this.ldapConfig = Config.ConfigFactory.GetConfig();
        }
        /// <summary>
        /// LDAPʂvpeBǂݎ
        /// </summary>
        /// <param name="result">LDAP</param>
        /// <param name="propertyName">wvpeB</param>
        /// <returns>vpeB΂̓e𕶎񉻁AȂ΋󕶎</returns>
        string getProperty(SearchResult result, string propertyName)
        {
            ResultPropertyValueCollection col = result.Properties[propertyName];
            if (col == null) return "";
            if (col.Count == 0) return "";

            if (col[0] == null) return "";
            if(col[0] is string) return StringUtil.StringValue( col[0] );
            if (col[0] is byte[]) return System.Text.Encoding.ASCII.GetString((byte[])col[0]);

            return "";
        }

        /// <summary>
        /// LDAPuid͂ƓcnGg[TBꂪȂ킿LDAPɓo^ꂽ[U[
        /// </summary>
        /// <param name="loginId">uid</param>
        /// <returns>Gg[΂̃Gg[琶UserIuWFNgAȂnull</returns>
        protected override OFW.Auth.Identity LoadIdentity(string loginId)
        {
            OFW.Auth.Identity identity = new Identity();

            string adPath = this.ldapConfig.GetAppSettingString("LdapUrl", "LDAP://localhost:10389/dc=example,dc=com");
            string ldappricipal = this.ldapConfig.GetAppSettingString("LdapPrincipal", "uid=admin,ou=system");
            string credentials = this.ldapConfig.GetAppSettingString("LdapCredentials", "secret");
            try
            {

                DirectoryEntry entry = new DirectoryEntry(adPath, ldappricipal, credentials, AuthenticationTypes.None);
                // gprincipal ȂNativeObject(炵)
                Object obj = entry.NativeObject;

                //^[Qbg[U[
                DirectorySearcher search = new DirectorySearcher();
                search.SearchRoot = entry;
                //uid = ̓[U[IDcnl
                search.Filter = "(&(uid=" + loginId + ")(cn=*))";
                SearchResult result = search.FindOne();
                if (result == null) return null;

                identity.User = new OFW.Auth.NullUser();

                string password = getProperty(result, "userPassword");//crypt method擪ɂ


                //B̃[
                OFW.Acl.IAclRole role = new OFW.Acl.AclRole();
                role.id = 0;
                role.name = "null user";



                return identity;
            }
            catch (Exception)
            {

                return null;

            }
        }
        /// <summary>
        /// pX[h
        /// </summary>
        /// <param name="loginId"></param>
        /// <param name="credential"></param>
        /// <returns></returns>
        protected override bool VerifyCredential(string loginId, string credential)
        {
            /* TODO: pX[h
            Regex re = new Regex("^\\{(SHA|MD5)\\}");
            if (re.IsMatch(password))
            {
                user.Password = re.Replace(password, "");
            }
            else
            {
                user.Password = password;
            }
             * */
            return true;
        }
    }
}
