using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Models;
using OFW.Auth.Model;
using OFW.Auth.Model.TableRow;

namespace OFW.Auth.Model.TableProperty
{
    /// <summary>
    /// table auth_usersɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class AuthUsersTableProperty : EntityProperty
    {
		///<summary>[login_id]</summary>
		public FieldProperty LoginId;
		///<summary>[name]</summary>
		public FieldProperty Name;
		///<summary>[password]</summary>
		public FieldProperty Password;
		///<summary>[description]</summary>
		public FieldProperty Description;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public AuthUsersTableProperty()
        {
        	this.EntityName = "auth_users";
			LoginId = FieldProperty.NewInstance("varchar", "auth_users", "login_id","[login_id]", 64, 0, 0, false, "",true);
			Name = FieldProperty.NewInstance("varchar", "auth_users", "name","[name]", 100, 0, 0, false, "",false);
			Password = FieldProperty.NewInstance("varchar", "auth_users", "password","[password]", 100, 0, 0, false, "",false);
			Description = FieldProperty.NewInstance("varchar", "auth_users", "description","[description]", 500, 0, 0, true, "",false);
			
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
			yield return this.LoginId;
			yield return this.Name;
			yield return this.Password;
			yield return this.Description;
			
        }
        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.LoginId;
            
        }
    }
}