using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Reflection;
using OFW.Log;
using OFW.Models;
using OFW.FieldProperties;
using ODP = Oracle.DataAccess.Client;
namespace OFW.Database.Oracle
{
    /// <summary>
    /// ORACLEpConnection.
    /// </summary>
    public class OracleConnection : OFW.Database.Connection
    {
        /// <summary>
        /// Oo
        /// </summary>
        private OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        ODP.OracleConnection connection;
        ODP.OracleTransaction transaction;
        static string privateKey = "craftsql";

        protected override void OpenInternal(System.Data.IsolationLevel isolation, bool beginTransaction)
        {
            
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                this.connection = new ODP.OracleConnection(BuildConnectionString()); ;
                

                this.isolation = isolation;//TODO:ftHgisolation̕ۑƕ
                connection.Open();
                if (beginTransaction)
                {
                    this.BeginTransaction(this.isolation);
                }
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        protected string BuildConnectionString()
        {
            ODP.OracleConnectionStringBuilder builder = new ODP.OracleConnectionStringBuilder();

            if (this.config.EncryptUser)
            {
                OFW.Util.Crypt crypt = new OFW.Util.Crypt();
                builder.UserID = crypt.DecryptStringEx(this.config.User, privateKey);
                builder.Password = crypt.DecryptStringEx(this.config.Password, privateKey);
            }
            else
            {
                builder.UserID = this.config.User;
                builder.Password = this.config.Password;
            }
            builder.DataSource = this.config.Url;
            string connectionString = builder.ConnectionString;
            if (this.config.Option != "")
            {
                connectionString += ";" + this.config.Option;
            }
            return connectionString;
        }
        protected override void CloseInternal(bool commitTransaction)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                if (this.connection != null)
                {
                    if (this.transaction != null)
                    {
                        if (commitTransaction)
                        {
                            this.CommitTransaction();
                        }
                        else
                        {
                            this.RollbackTransaction();
                        }
                    }
                    this.connection.Close();
                    this.connection = null;
                }

            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        protected override void BeginTransactionInternal(System.Data.IsolationLevel isolation)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                // ݂̐ڑgUNV擾Ă
                this.transaction = this.connection.BeginTransaction(isolation);
            }
            catch (InvalidOperationException ioex)
            {

                OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex, this.currentUser);
                handler.WriteLog();
                // gUNV̓T|[gĂ܂B
                throw ioex;
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        protected override void CommitTransactionInternal()
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Commit();
                }
            }
            catch (InvalidOperationException ioex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex, this.currentUser);
                handler.WriteLog();
                // gUNV́AɃR~bg܂̓[obNĂ܂B
                // ܂́AڑؒfĂ܂
                throw ioex;
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        protected override void RollbackTransactionInternal()
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Rollback();
                    //rollbackAp͂Ȃ̂ō폜Ă
                    this.transaction = null;
                }
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        protected override System.Data.Common.DbCommand CreateDbCommand(Command command)
        {
            ODP.OracleCommand actCommand = new ODP.OracleCommand(command.Text, this.connection);

            actCommand.CommandType = command.CommandType;
            actCommand.BindByName = true;
            foreach (Parameter p in command.Parameters)
            {
                if (p is OracleParameter)
                {
                    actCommand.Parameters.Add((p as OracleParameter).toOdpParameter());
                    continue;
                }

                ODP.OracleParameter parameter = actCommand.CreateParameter();
                parameter.ParameterName = p.ParameterName;
                parameter.DbType = p.ParameterType;
                parameter.Value = FixValue(p.ParameterValue);
                if ((p.ParameterType == DbType.String) || (p.ParameterType == DbType.StringFixedLength))
                {
                    if (p.Precision == 0)
                    {
                        if (p.ParameterValue != null)
                        {
                            parameter.Size = p.ParameterValue.ToString().Length;

                        }
                    }
                    else
                    {
                        parameter.Size = p.Precision;
                    }
                }
                else
                {
                    parameter.Size = p.Length;
                    parameter.Precision = (byte)p.Precision;
                    parameter.Scale = (byte)p.Scale;
                }
                parameter.Direction = p.ParameterDirection;
                actCommand.Parameters.Add(parameter);

            }
            return actCommand;
        }

        protected override System.Data.Common.DbDataAdapter CreateDataAdapter()
        {
            ODP.OracleDataAdapter da = new ODP.OracleDataAdapter();
            return da;
        }

        public override DateTime SystemDate()
        {
            //̃NG[AR}hƂ͕ʂ̐ڑgpB
            ODP.OracleConnection connection = new ODP.OracleConnection(this.BuildConnectionString());
            try
            {
                connection.Open();
                string q = "SELECT sysdate from DUAL";
                ODP.OracleCommand command = connection.CreateCommand();
                command.CommandText = q;
                command.Connection = connection;
                object d = command.ExecuteScalar();

                //X댯...܂null͂肦ȂB
                return (DateTime)d;
            }
            finally
            {
                connection.Close();
            }
        }

        protected override ConnectionException BuildException(System.Data.Common.DbException ex, params Command[] commands)
        {
            ODP.OracleException e = (ODP.OracleException)ex;
            ConnectionException newException = new ConnectionException(e.Message,
                e.Number,
                0,
                e.DataSource,
                e.Procedure,
                0,
                commands
            );

            return newException;
        }
        /// <summary>
        /// e[u̍\𒲂ׂ
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public override IEntityProperty DescribeTable(string tableName)
        {
            string query = @"SELECT 
  COLUMNS.TABLE_NAME , 
  COLUMNS.COLUMN_NAME, 
  COLUMNS.DATA_TYPE, 

  COLUMNS.DATA_LENGTH,
  COLUMNS.DATA_PRECISION,
  COLUMNS.DATA_SCALE,
  COLUMNS.CHAR_LENGTH,
  COLUMNS.NULLABLE,
  COLUMNS.DATA_DEFAULT COLUMN_DEF,
  DECODE(C1.CONSTRAINT_TYPE , 'P',1,0) IS_PRIMARY_KEY ,
  COMMENTS.COMMENTS
FROM USER_TAB_COLUMNS  COLUMNS
LEFT JOIN
(
  USER_CONSTRAINTS C1
  INNER JOIN USER_CONS_COLUMNS C2 
  ON  C1.TABLE_NAME = C2.TABLE_NAME 
  AND C1.CONSTRAINT_NAME = C2.CONSTRAINT_NAME 
  AND C1.CONSTRAINT_TYPE = 'P' 
)
ON COLUMNS.TABLE_NAME = C1.TABLE_NAME
AND COLUMNS.COLUMN_NAME = C2.COLUMN_NAME

LEFT JOIN USER_COL_COMMENTS COMMENTS
ON COLUMNS.TABLE_NAME = COMMENTS.TABLE_NAME
AND COLUMNS.COLUMN_NAME = COMMENTS.COLUMN_NAME

WHERE


UPPER(COLUMNS.TABLE_NAME) = UPPER(:table_name) 
ORDER BY COLUMNS.TABLE_NAME, COLUMNS.COLUMN_ID

";

            Command command = new Command(query, CommandType.Text);
            command.SetParameter(new Parameter(":table_name", DbType.String, tableName));

            DataSet columnInfo = ExecuteQuery(command);


            if (columnInfo.Tables[0].Rows.Count == 0) return null;

            DefaultTableProperties property = new DefaultTableProperties();
            foreach (DataRow row in columnInfo.Tables[0].Rows)
            {

                FieldProperty p = createFieldProperty(row);
                if (p != null)
                {
                    property.fieldList.Add(p);
                }
            }
            property.EntityName = tableName;

            return property;
        }
        private FieldProperty createFieldProperty(DataRow row)
        {
            //ɉ
            string tableName = OFW.Util.StringUtil.StringValue(row["TABLE_NAME"]);
            string columnName =  OFW.Util.StringUtil.StringValue(row["COLUMN_NAME"]);
            bool isNullable = OFW.Util.NumberUtil.BoolValue(row["NULLABLE"]);
            bool isPrimaryKey = OFW.Util.NumberUtil.BoolValue(row["IS_PRIMARY_KEY"]);
            string displayName = OFW.Util.StringUtil.StringValue(row["COMMENTS"]);
            object defaultValue = Filter(row["COLUMN_DEF"]);
            string dataType = OFW.Util.StringUtil.StringValue(row["DATA_TYPE"]).ToLower();
            int dataLength = OFW.Util.NumberUtil.Value<int>(row["DATA_LENGTH"]);
            int? dataPrecision = OFW.Util.NumberUtil.Value<int?>(row["DATA_PRECISION"]);
            int? dataScale = OFW.Util.NumberUtil.Value<int?>(row["DATA_SCALE"]);
            int? charLength = OFW.Util.NumberUtil.Value<int?>(row["CHAR_LENGTH"]);

            //data_type,precision,scale瓱
            string sqlTypeName  = "";
            int length = 0; 
            int precision = 0; 
            int scale = 0;

            if (dataType == "char")
            {
                sqlTypeName = "char";
                length = dataLength;
                precision = charLength.Value;
            }
            else if (dataType == "nchar")
            {
                sqlTypeName = "nchar";
                length = dataLength;
                precision = charLength.Value; ;
            }
            else if (dataType == "varchar2" || dataType == "varchar")
            {
                sqlTypeName = "varchar";
                length = dataLength;
                precision = charLength.Value; ;
            }
            else if (dataType == "nvarchar2" || dataType == "nvarchar")
            {
                sqlTypeName = "nvarchar";
                length = dataLength;
                precision = charLength.Value; ;
            }
            else if (dataType == "number")
            {
                if (dataPrecision == null)
                {
                    if (dataScale == null)
                    {
                        sqlTypeName = "float";
                        length = 8;
                        precision = 15;
                        scale = 0;
                    }
                    else //
                    {
                        sqlTypeName = "int";
                        length = 4;
                        precision = 10;
                        scale = 0;
                    }
                }
                else
                {
                    sqlTypeName = "decimal";
                    length = dataLength;
                    precision = OFW.Util.NumberUtil.Value<int>( dataPrecision );
                    scale = OFW.Util.NumberUtil.Value<int>(dataScale);
                }
            }
            else if (dataType == "date" || dataType == "timestamp")
            {
                sqlTypeName = "datetime";
                length = 16;
                precision = 23;
                scale = 3;
            }

            FieldProperty p = FieldProperty.NewInstance(sqlTypeName,
                tableName,
                columnName,
                displayName,
                length,
                precision,
                scale,
                isNullable,
                defaultValue,
                isPrimaryKey);

            return p;

        }
        /// <summary>
        /// e[u\擾
        /// TODO:
        /// </summary>
        /// <param name="tableName">e[u</param>
        /// <returns>e[u\</returns>
        public override DataSet ListTables(string tableName)
        {
            Command command = new Command("SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME LIKE :tableName ORDER BY TABLE_NAME", CommandType.Text);
            command.SetParameter(new Parameter(":tableName", DbType.String, tableName));

            return ExecuteQuery(command);
        }
        public override string NamedParameterPrefix()
        {
            return ":";
        }
        public override string NamedParameterSuffix()
        {
            return "";
        }
    }
}
