using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Database.SQLite
{
    /// <summary>
    /// SQLitep
    /// </summary>
    public class SQLiteConnection : OFW.Database.Connection
    {
        OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        System.Data.SQLite.SQLiteConnection connection;
        System.Data.SQLite.SQLiteTransaction transaction;

        protected override void OpenInternal(System.Data.IsolationLevel isolation, bool beginTransaction)
        {
            logger.Info(System.Reflection.MethodInfo.GetCurrentMethod().Name, " open");
            try
            {
                this.connection = new System.Data.SQLite.SQLiteConnection(BuildConnectionString());
                this.isolation = isolation;//TODO:ftHgisolation̕ۑƕ
                connection.Open();
                if (beginTransaction)
                {
                    this.BeginTransaction(this.isolation);
                }
            }
            catch (Exception ex)
            {
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw;
            }
        }
        string BuildConnectionString()
        {
            System.Data.SQLite.SQLiteConnectionStringBuilder builder = new System.Data.SQLite.SQLiteConnectionStringBuilder();
            builder.DataSource = this.config.Url;
            builder.DefaultTimeout = this.config.ConnectionTimeout;

            return builder.ToString();
        }
        protected override void CloseInternal(bool commitTransaction)
        {
            logger.Debug(System.Reflection.MethodInfo.GetCurrentMethod().Name, " close tran=" + commitTransaction.ToString());
            try
            {
                if (this.connection != null)
                {
                    if (this.transaction != null)
                    {
                        logger.Debug(System.Reflection.MethodInfo.GetCurrentMethod().Name, " had transaction");
                        if (commitTransaction)
                        {
                            logger.Debug(System.Reflection.MethodInfo.GetCurrentMethod().Name, " commit");
                            this.transaction.Commit();
                        }
                        else
                        {
                            logger.Debug(System.Reflection.MethodInfo.GetCurrentMethod().Name, " rollback");
                            this.transaction.Rollback();
                        }
                        this.transaction = null;
                    }
                    this.connection.Close();
                    this.connection = null;
                }

            }
            catch (Exception ex)
            {

                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw;
            }
        }

        protected override void BeginTransactionInternal(System.Data.IsolationLevel isolation)
        {
            try
            {
                // ݂̐ڑgUNV擾Ă
                this.transaction = this.connection.BeginTransaction();
            }
            catch (InvalidOperationException ioex)
            {

                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex);
                builder.WriteLog();
                // gUNV̓T|[gĂ܂B
                throw ioex;
            }
            catch (Exception ex)
            {

                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }

        protected override void CommitTransactionInternal()
        {
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Commit();
                }
            }
            catch (InvalidOperationException ioex)
            {
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex);
                builder.WriteLog();
                // gUNV́AɃR~bg܂̓[obNĂ܂B
                // ܂́AڑؒfĂ܂
                throw ioex;
            }
            catch (Exception ex)
            {
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                // gUNṼR~bgɃG[܂
                throw ex;
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
            }

        }

        protected override void RollbackTransactionInternal()
        {
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Rollback();
                    //rollbackAp͂Ȃ̂ō폜Ă
                    this.transaction = null;
                }
            }
            catch (InvalidOperationException ioex)
            {
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex);
                builder.WriteLog();
                // gUNV́AɃR~bg܂̓[obNĂ܂B
                // ܂́AڑؒfĂ܂
                throw ioex;
            }
            catch (Exception ex)
            {
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                // gUNṼR~bgɃG[܂
                throw ex;
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
            }
        }

        protected override System.Data.Common.DbCommand CreateDbCommand(Command command)
        {
            System.Data.SQLite.SQLiteCommand dbcommand = new System.Data.SQLite.SQLiteCommand(command.Text, this.connection, this.transaction);
            dbcommand.CommandType = command.CommandType;
            foreach (Parameter p in command.Parameters)
            {
                System.Data.SQLite.SQLiteParameter param = new System.Data.SQLite.SQLiteParameter();
                param.ParameterName = p.ParameterName;
                param.DbType = p.ParameterType;
                param.Value = FixValue(p.ParameterValue);
                param.Size = p.Length;
                //sqliteɂprecisionscaleȂ
                param.Direction = p.ParameterDirection;
                dbcommand.Parameters.Add(param);

            }

            return dbcommand;
        }

        protected override System.Data.Common.DbDataAdapter CreateDataAdapter()
        {
            System.Data.SQLite.SQLiteDataAdapter da = new System.Data.SQLite.SQLiteDataAdapter();
            return da;
        }

        public override DateTime SystemDate()
        {
            return DateTime.Now;
        }

        public override int GetLastIdentity()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        protected override ConnectionException BuildException(System.Data.Common.DbException ex, params Command[] commands)
        {
            System.Data.SQLite.SQLiteException sqlException = (System.Data.SQLite.SQLiteException)ex;
            ConnectionException newException = new ConnectionException(sqlException.Message,
                (int)sqlException.ErrorCode,
                0,
                this.config.Url,
                "",
                0,
                commands
            );

            return newException;
        }
    }
}
