using System;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using System.Data;
using OFW.Models;
using OFW.FieldProperties;
namespace OFW.Database
{
    /// <summary>
    /// Ae[uʂ̃}bv
    /// </summary>
    /// <typeparam name="TEntity"></typeparam>
    public class AssociationMapper<TEntity> where TEntity : Entity, new()
    {
        public EntityProperty baseTableProperty;
        public List<Association> associationsToMany;
        public List<Association> associationsToOne;
        IEnumerator rowEnumerator;
        DataRow currentRow;
        DataRow previousRow;
        bool endOfRows;
        Dictionary<string, PropertyInfo> referenceFieldProperty;

        Dictionary<string, Type> referenceFieldListType;
        Dictionary<string, MethodInfo> mapMethod;
        Dictionary<string, ConstructorInfo> constructors;

        public AssociationMapper()
        {
            referenceFieldProperty = new Dictionary<string, PropertyInfo>();
            referenceFieldListType = new Dictionary<string, Type>();
            mapMethod = new Dictionary<string, MethodInfo>();
            constructors = new Dictionary<string, ConstructorInfo>();

            associationsToMany = new List<Association>();
            associationsToOne = new List<Association>();
        }
        /// <summary>
        /// ̊֘A̎qvfǉ
        /// </summary>
        /// <param name="associations"></param>
        public AssociationMapper<TEntity> add(params Association[] associations)
        {
            foreach (Association a in associations)
            {
                if (a.multiplicity == Association.Multiplicity.TO_ONE)
                {
                    this.associationsToOne.Add(a);
                    continue;
                }
                if (a.multiplicity == Association.Multiplicity.TO_MANY)
                {
                    this.associationsToMany.Add(a);
                    continue;
                }

            }
            return this;
        }
        public virtual List<TEntity> map(DataSet data)
        {
            string baseAlias = baseTableProperty.Alias;
            if (baseAlias == "") baseAlias = baseTableProperty.EntityName;

            List<TEntity> entities = new List<TEntity>();

            currentRow = null;
            previousRow = null;
            rowEnumerator = data.Tables[0].Rows.GetEnumerator();

            seekNext(0);
            previousRow = currentRow;

            while (!endOfRows)
            {
                TEntity entity = new TEntity();
                entity.Map(currentRow, baseAlias);

                int seek = 0;
                if (associationsToOne.Count > 0)
                {
                    foreach (Association reference in associationsToOne)
                    {
                        seek += mapToOne(baseTableProperty, entity, reference);
                    }
                }
                if (associationsToMany.Count > 0)
                {
                    foreach (Association reference in associationsToMany)
                    {
                        seek += mapToMany(baseTableProperty, entity, reference);
                    }
                }

                entities.Add(entity);
                seekNext(seek);
            }
            return entities;
        }
        bool isNull(object value)
        {
            if (value == null)
            {
                return true;
            }
            if (value == DBNull.Value)
            {
                return true;
            }
            return false;
        }
        public virtual bool keyEquals(EntityProperty property, DataRow current,DataRow previous)
        {
            string baseAlias = property.Alias;
            if (baseAlias == "") baseAlias = property.EntityName;


            if (current == null) return false;
            if (previous == null) return false;
            bool equals = true;
            bool tested = false;
            foreach (FieldProperty p in property.PrimaryKeys())
            {
                tested = true;
                object currentValue = current[baseAlias + "__" + p.FieldName];
                object previousValue = previous[baseAlias + "__" + p.FieldName];
                if (isNull(currentValue))
                {
                    equals = false;
                    break;
                }
                if (isNull(previousValue))
                {
                    equals = false;
                    break;
                }

                if (!currentValue.Equals(previousValue))
                {
                    equals = false;
                    break;
                }
            }
            return equals & tested;
        }
        public virtual bool isEmpty(EntityProperty property, DataRow row)
        {
            string baseAlias = property.Alias;
            if (baseAlias == "") baseAlias = property.EntityName;

            bool empty = true;
            bool tested = false;
            foreach (FieldProperty keyField in property.PrimaryKeys())
            {
                tested = true;
                object keyFieldValue1 = row[baseAlias + "__" + keyField.FieldName];
                if (keyFieldValue1 == null) continue;
                if (keyFieldValue1 == DBNull.Value) continue;

                empty = false;
                break;
            }
            return empty & tested;
        }
        public virtual int mapToOne(EntityProperty entityProperty, Entity entity, Association reference)
        {
            if (isEmpty(reference.baseTable, currentRow)) return 0;

            PropertyInfo pi = findReferenceFieldProperty(entity.GetType(), reference.name);
            if (pi == null)
            {
                return 0;
            }

            Entity referenceEntity = null;
            if (reference.createEntity != null)
            {
                referenceEntity = reference.createEntity(currentRow, reference.baseTable.Alias);
            }
            else
            {
                referenceEntity = createAssociationObject(reference, currentRow);

            }

            int seek = doNextAssociation(referenceEntity, reference);
            setReferenceEntity(entity, pi, referenceEntity);
            return seek;
        }
        public virtual int mapToMany(EntityProperty entityProperty, Entity entity, Association reference)
        {
            PropertyInfo pi = findReferenceFieldProperty(entity.GetType(), reference.name);
            if (pi == null)
            {
                return 0;
            }
            int seek = 0;
            DataRow prev = currentRow;
            while (!endOfRows)
            {
                if (isEmpty(reference.baseTable, currentRow))
                {
                    break;
                }

                int seeked = 0;

                if (!keyEquals(entityProperty, currentRow, prev)) break;
                Entity referenceEntity = null;
                if (reference.createEntity != null)
                {
                    referenceEntity = reference.createEntity(currentRow, reference.baseTable.Alias);
                }
                else
                {
                    referenceEntity = createAssociationObject(reference, currentRow);
                }

                seeked += doNextAssociation(referenceEntity, reference);
                setReferenceEntity(entity, pi, referenceEntity);


                seek += seekNext(seeked);
            }
            return seek;
        }
        int doNextAssociation(Entity referenceEntity, Association reference)
        {
            int seek = 0;
            foreach (Association subAssociation in reference.associationsToOne)
            {
                seek += mapToOne(reference.baseTable, referenceEntity, subAssociation);
            }
            foreach (Association subAssociation in reference.associationsToMany)
            {
                seek += mapToMany(reference.baseTable, referenceEntity, subAssociation);
            }
            return seek;
        }
        public virtual int seekNext(int seek)
        {
            if (seek == 0)
            {
                endOfRows = !rowEnumerator.MoveNext();
                if (!endOfRows)
                {
                    previousRow = currentRow;
                    currentRow = rowEnumerator.Current as DataRow;
                }
                seek++;
            }
            return seek;
        }
        public virtual void setReferenceEntity(Entity entity, PropertyInfo pi, Entity referenceEntity)
        {
            Type ilistType = getListType(pi);
            if (ilistType != null)
            {
                //Xĝ̂擾
                object targetList = pi.GetValue(entity, null);
                if (targetList == null)
                {
                    targetList = Activator.CreateInstance(pi.PropertyType);
                    pi.SetValue(entity, targetList, null);
                }
                ilistType.InvokeMember("Add", BindingFlags.InvokeMethod, null, targetList, new object[] { referenceEntity });
            }
            else
            {
                pi.SetValue(entity, referenceEntity, null);
            }
        }
        public virtual Entity createAssociationObject(Association reference, DataRow row)
        {

            if (reference.baseTable.entityType != null)
            {
                string alias = reference.baseTable.Alias;
                if (alias == "") alias = reference.baseTable.EntityName;
                ConstructorInfo constructor = findConstructor(reference.baseTable.entityType);
                if (constructor == null) return null;

                Entity refObject = constructor.Invoke(null) as Entity;
                MethodInfo mi = findMapMethod(reference.baseTable.entityType);
                if (mi != null)
                {
                    mi.Invoke(refObject, new object[] { row, alias });
                }

                return refObject as Entity;
            }
            return null;
        }
        private PropertyInfo findReferenceFieldProperty(Type entityType, string propertyName)
        {
            string key = entityType.FullName + "#" + propertyName;
            if (referenceFieldProperty.ContainsKey(key))
            {
                return referenceFieldProperty[key];
            }
            PropertyInfo pi = entityType.GetProperty(propertyName);
            referenceFieldProperty[key] = pi;

            return pi;
        }
        private MethodInfo findMapMethod(Type entityType)
        {
            string key = entityType.FullName + "#" + "Map";
            if (mapMethod.ContainsKey(key))
            {
                return mapMethod[key];
            }
            MethodInfo pi = entityType.GetMethod("Map", new Type[] { typeof(DataRow), typeof(string) });
            mapMethod[key] = pi;

            return pi;
        }
        private ConstructorInfo findConstructor(Type entityType)
        {
            string key = entityType.FullName;
            if (constructors.ContainsKey(key))
            {
                return constructors[key];
            }
            ConstructorInfo pi = entityType.GetConstructor(new Type[] { });
            constructors[key] = pi;

            return pi;
        }
        private Type findReferenceFieldListType(Type entityType, string propertyName)
        {
            string key = entityType.FullName + "#" + propertyName;
            if (referenceFieldListType.ContainsKey(key))
            {
                return referenceFieldListType[key];
            }
            PropertyInfo pi = findReferenceFieldProperty(entityType, propertyName);
            if (pi == null) return null;

            Type ilistType = pi.PropertyType.GetInterface("System.Collections.IList");
            referenceFieldListType[key] = ilistType;//nullłǉĂ

            return ilistType;
        }
        private Type getListType(PropertyInfo pi)
        {
            string key = pi.DeclaringType.FullName + "#" + pi.Name;
            if (referenceFieldListType.ContainsKey(key))
            {
                return referenceFieldListType[key];
            }

            Type ilistType = pi.PropertyType.GetInterface("System.Collections.IList");
            referenceFieldListType[key] = ilistType;//nullłǉĂ

            return ilistType;
        }



    }
}
