using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;

namespace OFW.Database.Conditions
{
    /// <summary>
    /// Commandɑ΂WHEREɗ^鎮\B
    /// </summary>
    /// <example>
    /// 𐶐
    /// <code>
    ///        ComplexCondition condition = new ComplexCondition();
    ///        condition.AddCondition(new ColumnValueCondition(field1, 1, ">="));
    ///        condition.AddCondition("AND" ,new ColumnValueCondition(field1, 10, "&lt;="));
    ///        condition.AddCondition("OR", new ColumnValueCondition(field1, 100, "&lt;="));
    ///        condition.AddCondition("OR", new ColumnValueCondition(field2, "101010101", "="));
    ///        condition.AddCondition("OR", new ColumnValueCondition(field2, new string[] { "10","20" }, "IN"));
    ///
    ///        ComplexCondition cond2 = new ComplexCondition();
    ///        cond2.AddCondition(new ColumnValueCondition(field1, 1, ">="));
    ///        cond2.AddCondition("AND", new ColumnValueCondition(field1, 10, "&lt;="));
    ///        cond2.AddCondition("OR", new ColumnValueCondition(field1, 100, "&lt;="));
    ///        cond2.AddCondition("OR", new ColumnValueCondition(field2, "101010101", "="));
    ///        cond2.AddCondition("OR", new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"));
    ///        cond2.AddCondition("OR", new ColumnValueCondition(field2, new string[] { "10", "20" }, "BETWEEN"));
    ///
    ///        condition.AddCondition("AND", cond2);
    ///
    ///        string expression = condition.BuildCondition();
    ///        //ʂ͂̂悤ɂȂ
    ///        // ( test_table3.field1 >= @test_table3__field1 ) 
    ///        // AND ( test_table3.field1 &lt;= @test_table3__field1 ) 
    ///        // OR ( test_table3.field1 &lt;= @test_table3__field1 )
    ///        // OR ( test_table3.field2 = @test_table3__field2 ) 
    ///        // OR ( test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) ) 
    ///        // AND (  ( test_table3.field1 >= @test_table3__field1 ) 
    ///        // AND ( test_table3.field1 &lt;= @test_table3__field1 ) 
    ///        // OR ( test_table3.field1 &lt;= @test_table3__field1 ) 
    ///        // OR ( test_table3.field2 = @test_table3__field2 ) 
    ///        // OR ( test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) ) 
    ///        // OR ( test_table3.field2 BETWEEN @test_table3__field2_0 AND @test_table3__field2_1 )  ) 
    /// </code>
    /// 
    /// </example>
    /// 
    public abstract class Condition
    {
        /// <summary>
        /// Zq
        /// </summary>
        public string ConditionOperator;

        /// <summary>
        /// ̑gݗ
        /// </summary>
        /// <returns>gݗĂ</returns>
        public virtual string BuildCondition()
        {
            StringBuilder b = new StringBuilder();
            b.Append(BuildExpression());

            return b.ToString();
        }
        /// <summary>
        /// Expression
        /// </summary>
        /// <returns></returns>
        public virtual string BuildExpression()
        {
            return "";
        }
        /// <summary>
        /// p[^擾iabstractj
        /// </summary>
        /// <returns></returns>
        public abstract List<Parameter> GetParameters();
        
    }



}
